package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author: yaoyongming
 * @date: 2023/9/14 16:25
 */
@Slf4j
@Service
public class VerticalOutStorageAchieve implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 区域字典
     */
    private static final String MDM_CUSTOMIZE_ORG = "MDM_CUSTOMIZE_ORG";

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    @Override
    public String getVariableCode() {
        return "verticalOutStorageAchieve";
    }

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    @Override
    public String getVariableName() {
        return "区域出库达成率";
    }

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    @Override
    public Integer getSort() {
        return 1;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.CONTRACT);
        return list;
    }

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        //区域出库达成率=垂直实际销售额（区域）【来自垂直销售业绩表】/绩效版销售任务出库额（区域）【来自销售任务】，根据方案上的区域维度进行筛选，统计该维度下的所有产品数据
        Validate.notNull(calculateDto.getActivityOrgCode(), "区域不能为空");
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
        SalesPerformanceDto dto = new SalesPerformanceDto();
        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode(MDM_CUSTOMIZE_ORG, calculateDto.getActivityOrgCode());
        dto.setRegion(dictDataVo.getDictValue());
        dto.setSalesMonth(calculateDto.getYearMonthLy().replace("-", ""));
        BigDecimal salesAmount = salesPerformanceVoService.findSalesAmount(dto);
        SalesGoalDto dto2 = new SalesGoalDto();
        dto2.setRegionCode(calculateDto.getActivityOrgCode());
        dto2.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto2.setYearSalesTypeCode(YearSalesTypeEnum.ACHIEVEMENT.getCode());
        dto2.setYearMonthLyVariable(calculateDto.getYearMonthLy());
        BigDecimal discountAfter = salesGoalService.findDiscountAfter(dto2);

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), discountAfter.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : salesAmount.divide(discountAfter, 4, BigDecimal.ROUND_HALF_UP));
        return resultMap;
    }
}
