package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 促销金额
 */
//@Service
//@Slf4j
public class VerticalPromotionAmountRegister implements FormulaVariableRegister {

    @Override
    public String getVariableCode() {
        return "verticalPromotionAmount";
    }

    @Override
    public String getVariableName() {
        return "促销金额（垂直）";
    }

    @Override
    public Integer getSort() {
        return 2;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.CONTRACT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        return resultMap;
    }
}
