package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 垂直实际销售额
 */
@Service
@Slf4j
public class VerticalRealitySalesAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPerformanceService salesPerformanceService;

    @Override
    public String getVariableCode() {
        return "verticalRealitySalesAmount";
    }

    @Override
    public String getVariableName() {
        return "垂直实际销售额（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.CONTRACT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        //修改下面逻辑后请同步修改 折后出库达成率（垂直）VerticalAfterDiscountDeliveryYieldRate
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空");
        SalesPerformanceDto dto = new SalesPerformanceDto();
        dto.setSalesMonth(calculateDto.getYearMonthLy().replaceAll("-", ""));
        //不是下面设置值错了，是这张表字段错了
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setMaterialCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            dto.setCategoryCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            dto.setClassify(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            dto.setBrand(calculateDto.getBrandCode());
        } else {
//            throw new RuntimeException("垂直实际销售额，未录入产品或者产品层级信息");
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setShipToparty(calculateDto.getStoresCode());
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanName(), "零售商名称为空");
            Validate.notBlank(calculateDto.getActivityOrgName(), "区域名称为空");
            dto.setRetailer(calculateDto.getRetailBusinessmanName());
            dto.setRegion(calculateDto.getActivityOrgName());
        }
        dto.setExcludeProductCodeList(calculateDto.getExcludeProductCodeList());
        SalesPerformanceVo salesPerformanceVo = salesPerformanceService.findSalesAmountAndOutNumber(dto);

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (Objects.nonNull(salesPerformanceVo) && Objects.nonNull(salesPerformanceVo.getWarehsOutDiscountAmt())) {
            resultMap.put(this.getVariableCode(), salesPerformanceVo.getWarehsOutDiscountAmt());
        }
        return resultMap;
    }
}
