package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 垂直实际销售量
 */
@Service
@Slf4j
public class VerticalRealitySalesNumberRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SalesPerformanceService salesPerformanceService;
    @Override
    public String getVariableCode() {
        return "verticalRealitySalesNumber";
    }

    @Override
    public String getVariableName() {
        return "垂直实际销售量（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.CONTRACT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getYearMonthLy(),"年月不能为空");
        SalesPerformanceDto dto = new SalesPerformanceDto();
        dto.setSalesMonth(calculateDto.getYearMonthLy().replaceAll("-", ""));
        dto.setMaterialCode(calculateDto.getProductCode());
        dto.setShipToparty(calculateDto.getStoresCode());
        dto.setCategoryCode(calculateDto.getItemCode());
        dto.setClassify(calculateDto.getCategoryCode());
        dto.setBrand(calculateDto.getBrandCode());
        dto.setRegion(calculateDto.getSaleRegion());
        dto.setRetailer(calculateDto.getRetailBusinessmanName());
        dto.setExcludeProductCodeList(calculateDto.getExcludeProductCodeList());
        SalesPerformanceVo salesPerformanceVo = salesPerformanceService.findSalesAmountAndOutNumber(dto);
        
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(),salesPerformanceVo.getWarehsOutQty());
        return resultMap;
    }
}
