package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: ReturnTaxIncluded
 * @description: 区域梯度（垂直）
 * @author: hb
 * @create: 2023-03-20 10:39
 */
@Slf4j
@Service
public class VerticalRegionGradientRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    private String MDM_CUSTOMIZE_ORG = "MDM_CUSTOMIZE_ORG";

    @Override
    public String getVariableCode() {
        return "verticalRegionGradient";
    }

    @Override
    public String getVariableName() {
        return "区域梯度（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = Maps.newHashMap();
        String activityOrgCode = calculateDto.getActivityOrgCode();
        if (StringUtils.isEmpty(activityOrgCode)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(MDM_CUSTOMIZE_ORG));
        Map<String, String> keyToValueMap = Maps.newHashMap();
        mapDict.forEach((key, value) -> {
            value.forEach(dictVo -> {
                String keyCode = dictVo.getDictCode();
                Map<String, String> extendMap = dictVo.getExtendMap();
                String orgGradient = extendMap == null ? null : extendMap.get("org_gradient");
                keyToValueMap.put(keyCode, orgGradient);
            });
        });
        if (keyToValueMap.containsKey(activityOrgCode)) {
            String valueStr = keyToValueMap.get(activityOrgCode);
            BigDecimal valueBigDecimal;
            try {
                valueBigDecimal = new BigDecimal(valueStr);
            } catch (Exception e) {
                valueBigDecimal = BigDecimal.ZERO;
            }
            resultMap.put(this.getVariableCode(), valueBigDecimal);
        } else {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        return resultMap;
    }
}
