package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.kms.business.audit.match.sdk.constant.AuditSapVariableResultCalTypeConstant;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVariableVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-05-16
 */
@Slf4j
@Service
public class VerticalReturnPriceDiffRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private AuditSapVoService auditSapVoService;

    @Override
    public String getVariableCode() {
        return "verticalReturnPriceDiff";
    }

    @Override
    public String getVariableName() {
        return "退货价差（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.CONTRACT);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getDetailPlanItemCode(), "细案明细编码不能为空！");
        AuditSapVariableVo vo = new AuditSapVariableVo();
        vo.setCalType(AuditSapVariableResultCalTypeConstant.returnPriceDiff);
        vo.setPriceOrOtherActivity(calculateDto.getDetailPlanItemCode());
        vo.setGeneAccountingVouStatus("C");
        vo.setSaleVouType("ZRE2");

        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        AuditSapVariableVo result = auditSapVoService.getForVariable(vo);
        if (Objects.isNull(result) || Objects.isNull(result.getValue())) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), result.getValue());
        return resultMap;
    }
}
