package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.kms.business.invoice.statement.sdk.constant.InvoiceStatementConstant;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.DocumentType;
import com.biz.crm.tpm.business.variable.local.register.vertical.common.VariableKmsSettlementService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 含税进货额
 */
//@Service
//@Slf4j
public class VerticalStockTaxAmountRegister implements FormulaVariableRegister {

//    @Autowired(required = false)
//    private VariableKmsSettlementService variableKmsSettlementService;

    @Override
    public String getVariableCode() {
        return "verticalStockTaxAmount";
    }

    @Override
    public String getVariableName() {
        return "含税进货额（垂直）";
    }

    @Override
    public Integer getSort() {
        return 2;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.CONTRACT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
//        resultMap.put(this.getVariableCode(), variableKmsSettlementService.getValue(DocumentType.ACCEPTION, InvoiceStatementConstant.DOCUMENT_AMOUNT, calculateDto));
        return resultMap;
    }
}
