package com.biz.crm.tpm.business.variable.local.register.vertical.common;

import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementVariableDto;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.DocumentType;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 变量-kms结算单查询
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-17
 */
@Service
public class VariableKmsSettlementService {

    @Autowired(required = false)
    private InvoiceStatementVoService invoiceStatementVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    public BigDecimal getValue(DocumentType documentType, String valueName, CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月不能为空！");
        Validate.notNull(documentType, "未指定要查询的单据类型！");
        Validate.isTrue(StringUtils.isNotEmpty(calculateDto.getCustomerErpCode()) || StringUtils.isNotEmpty(calculateDto.getStoresCode()), "客户MDG编码和门店编码不能同时为空！");

        String productLevelCode = null;
        if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            productLevelCode = calculateDto.getItemCode();
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            productLevelCode = calculateDto.getCategoryCode();
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            productLevelCode = calculateDto.getBrandCode();
        }
        Validate.isTrue(StringUtils.isNotEmpty(calculateDto.getProductCode()) || StringUtils.isNotEmpty(productLevelCode), "产品编码、产品层级全部为空！");

        InvoiceStatementVariableDto dto = new InvoiceStatementVariableDto();
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty(productLevelCode)) {
            List<ProductVo> list = productVoService.findByProductLevelCodes(Lists.newArrayList(productLevelCode));
            if (!CollectionUtils.isEmpty(list)) {
                dto.setProductCodeList(list.stream().filter(e->StringUtils.isNotEmpty(e.getProductCode())).map(ProductVo::getProductCode).collect(Collectors.toList()));
            }
        }
        Validate.notEmpty(dto.getProductCodeList(), "产品层级为获取到产品数据！");
        dto.setSoldToPartyCode(calculateDto.getCustomerErpCode());
        dto.setDeliveryPartyCode(calculateDto.getStoresCode());
        dto.setDocumentType(documentType.getCode());
        dto.setYearMonthStr(calculateDto.getYearMonthLy());
        Map<String, BigDecimal> map = invoiceStatementVoService.findForVariable(dto);
        if (Objects.nonNull(map)) {
           return map.getOrDefault(valueName, BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }
}
