package com.biz.crm.tpm.business.variable.local.register.vertical.common;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.VariableRegisterConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-08
 */
@Component
@Slf4j
public class VariableVerticalCommonBuilder {

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 永辉-获取渠道
     * 返回null时表示不满足查询条件，变量应该返回0
     * 永辉 and 一级渠道为空 返回null
     * 用户 and 数据字典没配置渠道 返回null
     *
     * @param calculateDto
     * @return
     */
    public List<String> getYongHuiChannelNameList(CalculateDto calculateDto) {
        if (StringUtils.isEmpty(calculateDto.getRetailBusinessmanCode())
                || !StringUtils.equals(VariableRegisterConstants.yonghui, calculateDto.getRetailBusinessmanCode())) {
            return Lists.newArrayList();
        }

        if (StringUtils.isEmpty(calculateDto.getFirstChannelCode())) {
            return null;
        }
        List<DictDataVo> dictDataVos = null;
        if (StringUtils.equals(VariableRegisterConstants.firstChannelName_1, calculateDto.getFirstChannelCode())) {
            if (StringUtils.isEmpty(calculateDto.getSecondChannelCode())) {
                return null;
            }
            dictDataVos = dictDataVoService.findDictLowerByDictTypeCode(VariableRegisterConstants.secondChannelCode, calculateDto.getSecondChannelCode());
            if (CollectionUtils.isEmpty(dictDataVos)) {
                DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode(VariableRegisterConstants.secondChannelCode, calculateDto.getSecondChannelCode());
                dictDataVos.add(dictDataVo);
            }
        } else if (StringUtils.equals(VariableRegisterConstants.firstChannelName_2, calculateDto.getFirstChannelCode())) {
            dictDataVos = dictDataVoService.findDictLowerByDictTypeCode(VariableRegisterConstants.firstChannelName, VariableRegisterConstants.firstChannelName_2);
        } else {
            log.error("一级渠道编码[" + calculateDto.getFirstChannelCode() + "]在数据字典[" + VariableRegisterConstants.firstChannelName + "]不存在！");
        }

        if (CollectionUtils.isEmpty(dictDataVos)) {
            return null;
        }

        return dictDataVos.stream().map(DictDataVo::getDictValue).distinct().collect(Collectors.toList());
    }
}
