package com.biz.crm.tpm.business.variable.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.variable.local.entity.ConVariableDetailEntity;
import com.biz.crm.tpm.business.variable.local.mapper.ConVariableDetailMapper;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description 数据操作
 * @Author YangWei
 * @Date 2023/3/17 上午10:46
 */
@Component
public class ConVariableDetailRepository extends ServiceImpl<ConVariableDetailMapper, ConVariableDetailEntity> {

    /**
     * 删除明细
     * @param auditFormulaCode
     */
    public void deleteByAuditFormulaCode(String auditFormulaCode) {
        this.lambdaUpdate()
            .eq(ConVariableDetailEntity::getAuditFormulaCode, auditFormulaCode)
            .remove();
    }

    /**
     * 获取明细
     * @param detailDto
     * @return {@link List}<{@link ConVariableDetailVo}>
     */
    public List<ConVariableDetailVo> getItemDetail(ConVariableDetailDto detailDto) {
        detailDto.setTenantCode(TenantUtils.getTenantCode());
        detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.baseMapper.getItemDetail(detailDto);
    }
}