package com.biz.crm.tpm.business.variable.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.mapper.SourceCustomVariableMapper;
import com.biz.crm.tpm.business.variable.sdk.enums.CustomVariableSourceEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-24
 */
@Component
public class SourceCustomVariableRepository extends ServiceImpl<SourceCustomVariableMapper, SourceCustomVariableEntity> {

    @Autowired(required = false)
    private SourceCustomVariableMapper sourceCustomVariableMapper;

    public List<SourceCustomVariableEntity> findByIds(List<String> ids) {
        return this.lambdaQuery()
                .eq(SourceCustomVariableEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SourceCustomVariableEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(SourceCustomVariableEntity::getId, ids)
                .list();
    }

    public List<SourceCustomVariableEntity> findByVariableCodes(List<String> variableCodeList) {
        return this.lambdaQuery()
                .eq(SourceCustomVariableEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SourceCustomVariableEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(SourceCustomVariableEntity::getVariableCode, variableCodeList)
                .list();
    }

    public Integer findDuplicateCount(SourceCustomVariableEntity entity) {
        return this.lambdaQuery()
                .ne(StringUtils.isNotEmpty(entity.getId()), SourceCustomVariableEntity::getId, entity.getId())
                .and(q -> q.eq(SourceCustomVariableEntity::getVariableCode, entity.getVariableCode())
                        .or()
                        .eq(SourceCustomVariableEntity::getVariableName, entity.getVariableName()))
                .count();
    }

    public List<RegisterVariableVo> findForVariableList(String name, Integer limitSize) {
        return sourceCustomVariableMapper.findForVariableList(name, limitSize, TenantUtils.getTenantCode());
    }

    public List<RegisterVariableVo> findAllVariableList() {
        return this.sourceCustomVariableMapper.findAllVariableList(CustomVariableSourceEnum.EXECUTOR_INDICATOR.getCode(),TenantUtils.getTenantCode());
    }

    public List<RegisterVariableVo> variableAuthList(String isConfigure, String function, String name, Integer pageSize) {
        List<RegisterVariableVo> keyIndicatorVos = sourceCustomVariableMapper.variableAuthList(isConfigure, function, name, pageSize, TenantUtils.getTenantCode());
        int size = keyIndicatorVos.size();
        if (size == pageSize) {
            return keyIndicatorVos;
        }
        if (!YesOrNoEnum.YES.getCode().equals(isConfigure) && VariableFunctionEnum.AUDIT.getCode().equals(function)) {
            List<RegisterVariableVo> customVos = sourceCustomVariableMapper.customVariableAuthList(isConfigure, function, name, pageSize - keyIndicatorVos.size(), TenantUtils.getTenantCode());
            keyIndicatorVos.addAll(customVos);
        }
        return keyIndicatorVos;
    }
}
