package com.biz.crm.tpm.business.variable.local.utils;

import cn.hutool.core.util.ObjectUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

/**
 * @className: DateUtils
 * @description: 时间帮助类
 * @date: 2023/2/20 15:45.
 * @author: hb
 */
public class DateUtils {

    public static final String DATE_YEAR_MONTH_DAY = "yyyy-MM-dd";

    public static final String DATE_YEAR_MONTH_DAY_HOUR_POINTS_SECOND = "yyyy-MM-dd HH:mm:ss";

    public static final String DATE_YEAR_MONTH = "yyyy-MM";

    private static String localDateFormat(LocalDate localDate, String pattern){
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(pattern);
        return localDate.format(fmt);
    }

    public static List<String> getAllDatesInTheDateRange(LocalDate startLocalDate, LocalDate endLocalDate){
        List<String> localDateList = Lists.newArrayList();
        // 开始时间必须小于结束时间
        if (startLocalDate.isAfter(endLocalDate)) {
            return null;
        }
        while (startLocalDate.isBefore(endLocalDate)) {
            String localDateFormat = localDateFormat(startLocalDate, DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
            localDateList.add(localDateFormat);
            startLocalDate = startLocalDate.plusDays(1);
        }
        return localDateList;
    }

    public static LocalDateTime date2LocalDateTime(Date date){

        if (ObjectUtil.isNull(date)){
            return null;
        }

        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate date2LocalDate(Date date){
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate str2LocalDate(String strDate, String timeFormat){
        Date date = str2Date(strDate, timeFormat);

        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static long timeDifference(String startDate){

        SimpleDateFormat format = new SimpleDateFormat(DATE_YEAR_MONTH_DAY);
        Date startParse = null;

        try {
            startParse = format.parse(startDate);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }

        Date date = new Date();

        return cn.hutool.core.date.DateUtil.betweenDay(startParse, date, true);
    }

    public static Date str2Date(String strDate, String timeFormat){

        if (StringUtils.isEmpty(strDate)){
            return null;
        }

        SimpleDateFormat format = new SimpleDateFormat(timeFormat);

        Date parse = null;

        try {
            parse =  format.parse(strDate);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }

        return parse;

    }

    public static Integer timeDifferDay(LocalDateTime startDateTime, LocalDateTime endDateTime){

        if (startDateTime.isAfter(endDateTime)){
            return 0;
        }

        long day = startDateTime.until(endDateTime, ChronoUnit.DAYS);

        return Integer.parseInt(String.valueOf(day)) + 1;
    }

    public static Date localDate2Date(LocalDate localDate) {
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant1 = zonedDateTime.toInstant();
        Date from = Date.from(instant1);
        return from;
    }

}
