package com.biz.crm.tpm.business.variable.local.utils;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.repository.SourceCustomVariableRepository;
import com.biz.crm.tpm.business.variable.sdk.constant.SourceCustomVariableConstants;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.enums.CustomVariableSourceEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaCustomVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-24
 */
@Component
public class SourceCustomVariableUtil {

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private SourceCustomVariableRepository sourceCustomVariableRepository;

    @Autowired(required = false)
    private List<FormulaVariableRegister> formulaVariableRegisters;

    public void valCreate(SourceCustomVariableDto dto) {
        Validate.notEmpty(dto.getBusinessFormatCode(), "业态为空！");
        Validate.notEmpty(dto.getBusinessUnitCode(), "业务单元为空！");
        Validate.notEmpty(dto.getVariableCode(), "请选择变量！");
        Validate.notEmpty(dto.getParamsJson(), "请选择参数！");

        Map<String, String> map = dictToolkitService.findMapByDictTypeCode(SourceCustomVariableConstants.TPM_IMPLEMENTATION_INDICATORS);
        Validate.notNull(map, "未检测到数据字典[tpm_implementation_indicators]！");
        Validate.isTrue(map.containsKey(dto.getVariableCode()), "变量未在数据字典[tpm_implementation_indicators]中配置！");
        if (StringUtils.isEmpty(dto.getVariableName())) {
            dto.setVariableName(map.get(dto.getVariableCode()));
        }
    }

    public void valUpdate(SourceCustomVariableDto dto) {
        Validate.notEmpty(dto.getId(), "ID为空！");
        this.valCreate(dto);
    }

    public void checkDuplicate(SourceCustomVariableEntity entity) {
        Integer count = this.sourceCustomVariableRepository.findDuplicateCount(entity);
        Validate.isTrue(count == 0, "已存在相同变量！");
        for (FormulaVariableRegister variableRegister : formulaVariableRegisters) {
            Validate.isTrue(!entity.getVariableCode().equals(variableRegister.getVariableCode()), "变量编码[%s]已被固定变量[%s]使用！", entity.getVariableCode(), variableRegister.getVariableName());
            Validate.isTrue(!entity.getVariableName().equals(variableRegister.getVariableName()), "变量名称[%s]已被固定变量[%s]使用！", entity.getVariableCode(), variableRegister.getVariableName());
        }
    }

    public void packageEntity(SourceCustomVariableEntity entity) {
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDataSource(CustomVariableSourceEnum.EXECUTOR_INDICATOR.getCode());
    }
}
