package com.biz.crm.tpm.business.variable.local.utils;

import com.alibaba.fastjson.JSON;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableCalTestVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-06
 */
public class TestResultUtil {

    /**
     * 构建计算结果展示
     *
     * @param dto
     * @param calculateVos
     * @param variableNameMap
     * @return
     */
    public static VariableCalTestVo build(CalculateDto dto, List<CalculateVo> calculateVos, Map<String, String> variableNameMap) {
        VariableCalTestVo result = new VariableCalTestVo();
        //公式条件满足的计算结果
        List<CalculateVo> filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        Validate.isTrue(filterVos.size() < 2, "核销公式计算结果：多个核销公式条件同时满足！");
        //预估核销金额
        BigDecimal estimatedWriteOffAmount = null;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = filterVos.get(0).getFormulaValue();
        }

        //变量对应的值
        Map<String, BigDecimal> variableValueMap = new HashMap<>();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });

        //核销条件取值
        Map<String, String> conditionValueMap = new HashMap<>();
        //核销公式取值
        Map<String, String> formulaValueMap = new HashMap<>();
        dto.getFormulaInfoDtoList().forEach(formula -> {
            //核销条件
            Set<String> formulaCondition = com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil.getFormulaReplace(formula.getFormulaCondition());
            formulaCondition.forEach(v -> {
                if (conditionValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                    return;
                }
                conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
            });
            //核销公式
            Set<String> auditFormula = MathUtil.getFormulaReplace(formula.getFormula());
            auditFormula.forEach(v -> {
                if (formulaValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                    return;
                }
                formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
            });
        });
        result.setCondition(dto.getFormulaInfoDtoList().stream()
                .map(FormulaInfoDto::getFormulaConditionName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        result.setFormula(dto.getFormulaInfoDtoList().stream()
                .map(FormulaInfoDto::getFormulaName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        result.setConditionValue(String.join(" , ", conditionValueMap.values()));
        result.setFormulaValue(String.join(" , ", formulaValueMap.values()));
        result.setValue(estimatedWriteOffAmount);
        return result;
    }

}
