/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.service.SourceCustomVariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.SourceCustomVariableVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sourceCustomVariable"})
@Api(tags={"\u56fa\u5b9a\u6570\u636e\u6e90\u81ea\u5b9a\u4e49\u6838\u9500\u53d8\u91cf\u8868"})
public class SourceCustomVariableController {
    private static final Logger log = LoggerFactory.getLogger(SourceCustomVariableController.class);
    @Autowired(required=false)
    private SourceCustomVariableService sourceCustomVariableService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"findById"})
    public Result<SourceCustomVariableVo> findById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.sourceCustomVariableService.findById(id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"create"})
    public Result<?> create(@RequestBody SourceCustomVariableDto dto) {
        try {
            this.sourceCustomVariableService.create(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"update"})
    public Result<?> update(@RequestBody SourceCustomVariableDto dto) {
        try {
            this.sourceCustomVariableService.update(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.sourceCustomVariableService.enable(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.sourceCustomVariableService.disable(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

