/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.variable.local.register.ecommerce.ECommerceAuditDateRegister;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ControlsDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.ControlsVo;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableCalTestVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/variable"})
@Api(tags={"\u53d8\u91cf\u4e3b\u8868"})
public class VariableController {
    private static final Logger log = LoggerFactory.getLogger(VariableController.class);
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private ECommerceAuditDateRegister eCommerceAuditDateRegister;

    @ApiOperation(value="\u83b7\u53d6\u53d8\u91cf\u5217\u8868")
    @GetMapping(value={"variableList"})
    public Result<List<RegisterVariableVo>> variableList(@RequestParam(value="isConfigure") String isConfigure, @RequestParam(value="function") String function, @RequestParam(value="name", required=false) String name, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        try {
            return Result.ok((Object)this.variableService.variableList(isConfigure, function, name, pageSize));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u53d8\u91cf\u5217\u8868\uff08\u53ef\u505a\u6743\u9650\uff09")
    @GetMapping(value={"variableAuthList"})
    public Result<List<RegisterVariableVo>> variableAuthList(@RequestParam(value="isConfigure") String isConfigure, @RequestParam(value="function") String function, @RequestParam(value="name", required=false) String name, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        try {
            return Result.ok((Object)this.variableService.variableAuthList(isConfigure, function, name, pageSize));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u8ba1\u7b97")
    @PostMapping(value={"calTest"})
    public Result<VariableCalTestVo> calTest(@RequestBody CalculateDto dto) {
        try {
            return Result.ok((Object)this.variableService.calTest(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6574\u4f53\u7ba1\u63a7\u6d4b\u8bd5")
    @PostMapping(value={"overallControl"})
    public Result<ControlsVo> calTest(@RequestBody ControlsDto dto) {
        try {
            return Result.ok((Object)this.variableService.overallControl(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6307\u6807\u53d6\u503c")
    @PostMapping(value={"ecloseTest`"})
    public Result<?> ecloseTest(@RequestBody CalculateDto calculate) {
        try {
            Map<String, BigDecimal> resultMap = this.eCommerceAuditDateRegister.calculateVariable(calculate);
            return Result.ok(resultMap);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }
}

