/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.mapper.AuditExecuteIndicatorMapper;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorOnlyKeyVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditExecuteIndicatorRepository
extends ServiceImpl<AuditExecuteIndicatorMapper, AuditExecuteIndicator> {
    @Autowired(required=false)
    private AuditExecuteIndicatorMapper auditExecuteIndicatorMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<AuditExecuteIndicatorVo> findByConditions(Pageable pageable, AuditExecuteIndicatorDto auditExecuteIndicatorDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditExecuteIndicatorMapper.findByConditions((Page<AuditExecuteIndicatorVo>)page, auditExecuteIndicatorDto);
    }

    public void bulkSave(List<AuditExecuteIndicator> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.auditExecuteIndicatorMapper.bulkSave(entities);
    }

    public void updateByIdAndTenantCode(AuditExecuteIndicator entity, String tenantCode) {
        if (null == entity) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode) || StringUtils.isEmpty((CharSequence)entity.getId())) {
            return;
        }
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)entity.getId());
        ((AuditExecuteIndicatorMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public void updateBatchByIdAndTenantCode(Collection<AuditExecuteIndicator> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((AuditExecuteIndicatorMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public List<AuditExecuteIndicator> findListByCondition(AuditExecuteIndicatorDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || Objects.isNull(dto.getYearAndMonth()) || StringUtils.isEmpty((CharSequence)dto.getSalesOrgCode()) || StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isEmpty((CharSequence)dto.getIndicatorCode())) {
            throw new RuntimeException("\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\uff0c\u5e74\u6708\uff0c\u9500\u552e\u7ec4\u7ec7\uff0c\u5ba2\u6237\u7f16\u7801,\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditExecuteIndicator::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(AuditExecuteIndicator::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(AuditExecuteIndicator::getYearAndMonth, (Object)dto.getYearAndMonth())).eq(AuditExecuteIndicator::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(AuditExecuteIndicator::getCustomerCode, (Object)dto.getCustomerCode())).eq(AuditExecuteIndicator::getVariableCode, (Object)dto.getIndicatorCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getStoresCode()), AuditExecuteIndicator::getStoresCode, (Object)dto.getStoresCode())).list();
        return list;
    }

    public List<AuditExecuteIndicator> findByCode(String activeNumber, String indicatorName) {
        if (StringUtils.isEmpty((CharSequence)activeNumber) || StringUtils.isEmpty((CharSequence)indicatorName)) {
            throw new RuntimeException("\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u3001\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.auditExecuteIndicatorMapper.findByCode(activeNumber, indicatorName);
    }

    public List<AuditExecuteIndicatorVo> findByCodeList(List<String> activeNumberList, String indicatorName) {
        if (CollectionUtils.isEmpty(activeNumberList) || StringUtils.isEmpty((CharSequence)indicatorName)) {
            throw new RuntimeException("\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u3001\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.auditExecuteIndicatorMapper.findByCodeList(activeNumberList, indicatorName);
    }

    public List<AuditExecuteIndicator> findData(AuditExecuteIndicatorDto dto) {
        return this.auditExecuteIndicatorMapper.findData(dto);
    }

    public List<AuditExecuteIndicatorVo> findByActiveNumber(List<String> activeNumbers, String dockingSystem, String businessUnitCode) {
        return this.auditExecuteIndicatorMapper.findByActiveNumber(activeNumbers, dockingSystem, businessUnitCode);
    }

    public List<AuditExecuteIndicatorOnlyKeyVo> findByOnlyKeys(List<List<String>> keys, String tenantCode) {
        return this.auditExecuteIndicatorMapper.findByOnlyKeys(keys, tenantCode);
    }

    public AuditExecuteIndicator findByPeopleMonth(AuditExecuteIndicatorDto indicatorDto) {
        return (AuditExecuteIndicator)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditExecuteIndicator::getPersonCode, (Object)indicatorDto.getPersonCode())).eq(AuditExecuteIndicator::getYearAndMonth, (Object)indicatorDto.getYearAndMonth())).one());
    }

    public List<AuditExecuteIndicator> findListForVariable(AuditExecuteIndicatorDto dto) {
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)dto.getActiveNumber()) || AuditExecuteIndicatorParamBuilder.otherParamsVal(dto) ? 1 : 0) != 0, (String)"\u53d8\u91cf\u67e5\u8be2\u6267\u884c\u6307\u6807\u6570\u636e\uff0c\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), AuditExecuteIndicator::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessUnitCode()), AuditExecuteIndicator::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getActivityTypeCode()), AuditExecuteIndicator::getActivityTypeCode, (Object)dto.getActivityTypeCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getActivityFormCode()), AuditExecuteIndicator::getActivityFormCode, (Object)dto.getActivityFormCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getActiveNumber()), AuditExecuteIndicator::getActiveNumber, (Object)dto.getActiveNumber())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), AuditExecuteIndicator::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), AuditExecuteIndicator::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesRegionCode()), AuditExecuteIndicator::getSalesRegionCode, (Object)dto.getSalesRegionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()), AuditExecuteIndicator::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getStoresCode()), AuditExecuteIndicator::getStoresCode, (Object)dto.getStoresCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerRetailerCode()), AuditExecuteIndicator::getCustomerRetailerCode, (Object)dto.getCustomerRetailerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getPersonIdCard()), AuditExecuteIndicator::getPersonIdCard, (Object)dto.getPersonIdCard())).eq(StringUtils.isNotEmpty((CharSequence)dto.getFirstChannelCode()), AuditExecuteIndicator::getFirstChannelCode, (Object)dto.getFirstChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSecondChannelCode()), AuditExecuteIndicator::getSecondChannelCode, (Object)dto.getSecondChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductBrandCode()), AuditExecuteIndicator::getProductBrandCode, (Object)dto.getProductBrandCode())).in(!CollectionUtils.isEmpty((Collection)dto.getProductBrandCodeList()), AuditExecuteIndicator::getProductBrandCode, (Collection)dto.getProductBrandCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCategoryCode()), AuditExecuteIndicator::getProductCategoryCode, (Object)dto.getProductCategoryCode())).in(!CollectionUtils.isEmpty((Collection)dto.getProductCategoryCodeList()), AuditExecuteIndicator::getProductCategoryCode, (Collection)dto.getProductCategoryCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductItemCode()), AuditExecuteIndicator::getProductItemCode, (Object)dto.getProductItemCode())).in(!CollectionUtils.isEmpty((Collection)dto.getProductItemCodeList()), AuditExecuteIndicator::getProductItemCode, (Collection)dto.getProductItemCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), AuditExecuteIndicator::getProductCode, (Object)dto.getProductCode())).in(!CollectionUtils.isEmpty((Collection)dto.getProductCodeList()), AuditExecuteIndicator::getProductCode, (Collection)dto.getProductCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getHeadBudgetItemCode()), AuditExecuteIndicator::getHeadBudgetItemCode, (Object)dto.getHeadBudgetItemCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getMonthBudgetCode()), AuditExecuteIndicator::getMonthBudgetCode, (Object)dto.getMonthBudgetCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSpecification()), AuditExecuteIndicator::getSpecification, (Object)dto.getSpecification())).eq(StringUtils.isNotEmpty((CharSequence)dto.getIsTemporary()), AuditExecuteIndicator::getIsTemporary, (Object)dto.getIsTemporary())).eq(Objects.nonNull(dto.getYearAndMonth()), AuditExecuteIndicator::getYearAndMonth, (Object)dto.getYearAndMonth())).likeRight(Objects.nonNull(dto.getYearStr()), AuditExecuteIndicator::getYearAndMonth, (Object)dto.getYearStr())).eq(Objects.nonNull(dto.getActivityBeginDate()), AuditExecuteIndicator::getActivityBeginDate, (Object)dto.getActivityBeginDate())).eq(Objects.nonNull(dto.getActivityEndDate()), AuditExecuteIndicator::getActivityEndDate, (Object)dto.getActivityEndDate())).eq(StringUtils.isNotEmpty((CharSequence)dto.getVariableCode()), AuditExecuteIndicator::getVariableCode, (Object)dto.getVariableCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getIndicatorName()), AuditExecuteIndicator::getIndicatorName, (Object)dto.getIndicatorName())).eq(StringUtils.isNotEmpty((CharSequence)dto.getDockingSystem()), AuditExecuteIndicator::getDockingSystem, (Object)dto.getDockingSystem())).in(!CollectionUtils.isEmpty((Collection)dto.getCustomerCodes()), AuditExecuteIndicator::getCustomerCode, (Collection)dto.getCustomerCodes())).in(!CollectionUtils.isEmpty((Collection)dto.getStoresCodes()), AuditExecuteIndicator::getStoresCode, (Collection)dto.getStoresCodes())).list();
    }

    public List<AuditExecuteIndicator> getPersonnelWage(AuditExecuteIndicatorDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode())) {
            throw new RuntimeException("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode())) {
            throw new RuntimeException("\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPersonCode())) {
            throw new RuntimeException("\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(dto.getYearAndMonth())) {
            throw new RuntimeException("\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditExecuteIndicator::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(AuditExecuteIndicator::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(AuditExecuteIndicator::getPersonCode, (Object)dto.getPersonCode())).eq(AuditExecuteIndicator::getYearAndMonth, (Object)dto.getYearAndMonth())).eq(AuditExecuteIndicator::getIndicatorName, (Object)dto.getIndicatorName())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = new ArrayList();
        }
        return list;
    }

    public List<AuditExecuteIndicator> findSapDataByActiveNumbers(List<String> detailPlanItemCodes, List<String> indicatorNames) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditExecuteIndicator::getActiveNumber, detailPlanItemCodes)).in(AuditExecuteIndicator::getIndicatorName, indicatorNames)).select(new SFunction[]{AuditExecuteIndicator::getActiveNumber, AuditExecuteIndicator::getIndicatorName, AuditExecuteIndicator::getIndicatorValue, AuditExecuteIndicator::getBusinessFormatCode, AuditExecuteIndicator::getBusinessUnitCode}).list();
    }

    public List<AuditExecuteIndicatorVo> getMinusCompostQuantity(AuditExecuteIndicatorDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditExecuteIndicator::getActiveNumber, (Collection)dto.getDetailPlanItemCodes())).eq(AuditExecuteIndicator::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(AuditExecuteIndicator::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(AuditExecuteIndicator::getDockingSystem, (Object)dto.getDockingSystem())).eq(AuditExecuteIndicator::getIndicatorName, (Object)dto.getIndicatorName())).select(new SFunction[]{AuditExecuteIndicator::getActiveNumber, AuditExecuteIndicator::getIndicatorValue}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditExecuteIndicatorVos;
    }
}

