/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.alibaba.excel.util.Validate;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorDeductionAmountImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditExecuteIndicatorDeductionAmountImportProcess
implements ImportProcess<AuditExecuteIndicatorDeductionAmountImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteIndicatorDeductionAmountImportProcess.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    private static final String REGEX = "\\d{4}-\\d{2}";

    public Integer getBatchCount() {
        return 5000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, AuditExecuteIndicatorDeductionAmountImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, AuditExecuteIndicatorDeductionAmountImportVo> row : data.entrySet()) {
            String errInfo;
            int rowNum = row.getKey();
            AuditExecuteIndicatorDeductionAmountImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getYearAndMonthStr()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
            if (StringUtil.isEmpty((CharSequence)vo.getYearAndMonthStr())) {
                this.validateIsTrue(false, "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                try {
                    Date date = DateUtil.date_yyyy_MM.parse(vo.getYearAndMonthStr().trim());
                    this.validateIsTrue(vo.getYearAndMonthStr().trim().equals(DateUtil.date_yyyy_MM.format(date)), "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
                    vo.setYearAndMonth(date);
                }
                catch (Exception e) {
                    this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
                }
            }
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getIndicatorName()), "\u6267\u884c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getIsQualified()), "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getIsQualifiedReason()), "\u4e0d\u5408\u683c\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtil.isNotEmpty((CharSequence)vo.getRegionInspectCostsStr()), "\u6263\u51cf\u5927\u533a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtil.isNotEmpty((CharSequence)vo.getInspectCostsStr()), "\u6263\u51cf\u6d3b\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getStoresCode()), "\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            if (StringUtil.isEmpty((CharSequence)vo.getActivityStatus())) {
                this.validateIsTrue(false, "\u662f\u5426\u5173\u95ed\u6d3b\u52a8\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                this.validateIsTrue(BooleanEnum.FALSE.getSure().equals(vo.getActivityStatus()) || BooleanEnum.TRUE.getSure().equals(vo.getActivityStatus()), "\u662f\u5426\u5173\u95ed\u6d3b\u52a8\u53ea\u80fd\u662f[\u662f/\u5426]!");
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditExecuteIndicatorDeductionAmountImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e00\u6b65");
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        this.validate(data, resultErrorMap);
        if (!resultErrorMap.isEmpty()) {
            return resultErrorMap;
        }
        List importList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), AuditExecuteIndicatorDeductionAmountImportVo.class, AuditExecuteIndicatorDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.auditExecuteIndicatorService.bulkImportSave(importList);
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e8c\u6b65");
        return resultErrorMap;
    }

    private void validate(LinkedHashMap<Integer, AuditExecuteIndicatorDeductionAmountImportVo> data, Map<Integer, String> resultErrorMap) {
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Map regionMap = this.dictToolkitService.findConvertMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)regionMap), (String)"\u672a\u67e5\u8be2\u5230\u96f6\u552e\u5546\u533a\u57df\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map indicatorsMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_implementation_indicators");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)indicatorsMap), (String)"\u672a\u67e5\u8be2\u5230\u6267\u884c\u6307\u6807\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map qualifiedMap = this.dictToolkitService.findConvertMapByDictTypeCode("is_qualified");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)qualifiedMap), (String)"\u672a\u67e5\u8be2\u5230\u72b6\u6001\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map yesMap = this.dictToolkitService.findConvertMapByDictTypeCode("yes_or_no");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)yesMap), (String)"\u672a\u67e5\u8be2\u5230\u662f\u5426\u5173\u95ed\u6d3b\u52a8\u662f\u4e2a\u6570\u636e\u5b57\u5178yes_or_no!", (Object[])new Object[0]);
        data.forEach((index, item) -> {
            try {
                this.validateData((AuditExecuteIndicatorDeductionAmountImportVo)item, formatMap, unitMap, regionMap, indicatorsMap, qualifiedMap, yesMap, resultErrorMap, (Integer)index);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                String msg = "\u7b2c\u3010" + index + "\u3011\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                resultErrorMap.put((Integer)index, msg);
            }
        });
    }

    private void validateData(AuditExecuteIndicatorDeductionAmountImportVo dto, Map<String, String> formatMap, Map<String, String> unitMap, Map<String, String> regionMap, Map<String, String> indicatorsMap, Map<String, String> qualifiedMap, Map<String, String> yesMap, Map<Integer, String> errMap, Integer rowNum) {
        String retailerName;
        CustomerChannelVo channelVo = this.customerChannelVoService.findByCode(dto.getChannelCode());
        if (ObjectUtils.isNotEmpty((Object)channelVo)) {
            dto.setChannelName(channelVo.getCustomerChannelName());
        } else {
            this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801" + dto.getChannelCode() + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String employeeCode = indicatorsMap.get(dto.getIndicatorName());
        if (StringUtils.isNotBlank((CharSequence)employeeCode)) {
            dto.setIndicatorCode(employeeCode);
            dto.setIndicatorName(employeeCode);
        } else {
            this.validateIsTrue(false, "\u6267\u884c\u6307\u6807\u540d\u79f0:" + dto.getIndicatorName() + "\u672a\u5339\u914d\u5230\u6267\u884c\u6307\u6807\u7f16\u7801!");
        }
        String isQualifiedCode = qualifiedMap.get(dto.getIsQualified());
        if (StringUtils.isNotBlank((CharSequence)isQualifiedCode)) {
            dto.setIsQualifiedCode(isQualifiedCode);
        } else {
            this.validateIsTrue(false, "\u72b6\u6001:" + dto.getIsQualified() + "\u672a\u5339\u914d\u5230\u72b6\u6001\u7f16\u7801!");
        }
        String regionName = dto.getRegionName();
        if (StringUtils.isNotEmpty((CharSequence)regionName)) {
            String regionCode = regionMap.get(regionName);
            if (StringUtils.isNotBlank((CharSequence)regionCode)) {
                dto.setRegionCode(regionCode);
            } else {
                this.validateIsTrue(false, "\u6240\u5c5e\u5927\u533a\u540d\u79f0:" + regionName + "\u672a\u5339\u914d\u5230\u6240\u5c5e\u5927\u533a\u7f16\u7801!");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(retailerName = dto.getCustomerRetailerName()))) {
            List customerRetailerVoList = this.customerRetailerVoService.findByName(retailerName);
            if (CollectionUtils.isNotEmpty((Collection)customerRetailerVoList)) {
                if (customerRetailerVoList.size() == 1) {
                    dto.setCustomerRetailerCode((String)customerRetailerVoList.get(0));
                } else {
                    this.validateIsTrue(false, "\u6240\u5c5e\u96f6\u552e\u5546\u540d\u79f0:" + regionName + "\u5339\u914d\u5230\u6240\u5c5e\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u6b62\u4e00\u4e2a!");
                }
            } else {
                this.validateIsTrue(false, "\u6240\u5c5e\u96f6\u552e\u5546\u540d\u79f0:" + regionName + "\u672a\u5339\u914d\u5230\u6240\u5c5e\u96f6\u552e\u5546\u7f16\u7801!");
            }
        }
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
        }
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
        }
        try {
            dto.setYearAndMonth(DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr()));
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        if (StringUtil.isEmpty((CharSequence)dto.getRegionInspectCostsStr())) {
            this.validateIsTrue(false, "\u6263\u51cf\u5927\u533a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
        } else {
            try {
                dto.setRegionInspectCosts(new BigDecimal(dto.getRegionInspectCostsStr()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                this.validateIsTrue(false, "\u6263\u51cf\u6d3b\u52a8\u91d1\u989d\u4e0d\u5408\u6cd5!");
            }
        }
        if (StringUtil.isEmpty((CharSequence)dto.getInspectCostsStr())) {
            this.validateIsTrue(false, "\u6263\u51cf\u6d3b\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
        } else {
            try {
                dto.setInspectCosts(new BigDecimal(dto.getInspectCostsStr()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                this.validateIsTrue(false, "\u6263\u51cf\u6d3b\u52a8\u91d1\u989d\u4e0d\u5408\u6cd5!");
            }
        }
        this.validateIsTrue(StringUtil.isNotEmpty((CharSequence)dto.getIndicatorValueStr()), "\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            BigDecimal indicatorValue = new BigDecimal(dto.getIndicatorValueStr());
            dto.setIndicatorValue(indicatorValue);
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u6307\u6807\u503c(\u6570\u5b57)\u683c\u5f0f\u6709\u8bef");
        }
        dto.setDockingSystem("TPM");
        String customerCode = dto.getCustomerCode();
        if (StringUtils.isNotEmpty((CharSequence)customerCode) && StringUtils.isEmpty((CharSequence)dto.getCustomerName())) {
            ArrayList<String> codes = new ArrayList<String>(1);
            codes.add(customerCode);
            List baseByCustomerCodes = this.customerVoService.findBaseByCustomerCodes(codes);
            if (CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes) && baseByCustomerCodes.size() > 0) {
                dto.setCustomerName(((CustomerVo)baseByCustomerCodes.get(0)).getCustomerName());
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801" + customerCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        String storesCode = dto.getStoresCode();
        ArrayList<String> terminalCodeList = new ArrayList<String>(1);
        terminalCodeList.add(storesCode);
        List terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (CollectionUtils.isNotEmpty((Collection)terminalVos) && terminalVos.size() > 0) {
            dto.setStoresName(((TerminalVo)terminalVos.get(0)).getTerminalName());
        } else {
            this.validateIsTrue(false, "\u95e8\u5e97\u7f16\u7801" + storesCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String activityStatus = dto.getActivityStatus();
        String yesKey = yesMap.get(activityStatus);
        if (StringUtils.isNotBlank((CharSequence)yesKey)) {
            dto.setActivityStatusCode(yesKey);
        } else {
            this.validateIsTrue(false, "\u662f\u5426\u5173\u95ed\u6d3b\u52a8:" + yesKey + "\u672a\u5339\u914d\u5230\u662f\u5426\u5173\u95ed\u6d3b\u52a8\u7f16\u7801!");
        }
        String errInfo = this.validateGetErrorInfo();
        if (errInfo != null) {
            errMap.put(rowNum, errInfo);
        }
    }

    public Class<AuditExecuteIndicatorDeductionAmountImportVo> findCrmExcelVoClass() {
        return AuditExecuteIndicatorDeductionAmountImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868";
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_DEDUCTION_AMOUNT_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868-\u6838\u51cf\u91d1\u989d";
    }
}

