/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.Validate;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerOrgChannelStoresVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeFormDetailVo;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeRelationDetailVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorImportVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.SourceCustomVariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditExecuteIndicatorImportProcess
implements ImportProcess<AuditExecuteIndicatorImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteIndicatorImportProcess.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private List<FormulaVariableRegister> registerList;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private PromotersVoService promotersVoService;
    @Autowired(required=false)
    private SourceCustomVariableService sourceCustomVariableService;

    public Integer getBatchCount() {
        return 50000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditExecuteIndicatorImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e00\u6b65");
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        this.validate(data, resultErrorMap);
        if (CollectionUtil.isEmpty(resultErrorMap)) {
            log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e8c\u6b65");
            Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), AuditExecuteIndicatorImportVo.class, AuditExecuteIndicatorDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditExecuteIndicatorService.bulkImportSave(new ArrayList(dtoList));
        }
        return resultErrorMap;
    }

    private void validate(LinkedHashMap<Integer, AuditExecuteIndicatorImportVo> data, Map<Integer, String> resultErrorMap) {
        List promotersVos;
        List terminalVos;
        List itemVos;
        List productVos;
        List levelVos;
        List itemVos2;
        List itemVos3;
        List spList;
        List formList;
        List typeList;
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Map personMap = this.dictToolkitService.findConvertMapByDictTypeCode("ocm_user_category");
        HashSet cusCodes = new HashSet();
        HashSet typeCodes = new HashSet();
        HashSet formCodes = new HashSet();
        HashSet spCodes = new HashSet();
        HashSet detailPlanItemCodes = new HashSet();
        HashSet subDetailPlanItemCodes = new HashSet();
        HashSet terChannelCodes = new HashSet();
        HashSet brandCodes = new HashSet();
        HashSet proItemCodes = new HashSet();
        HashSet productCodes = new HashSet();
        HashSet budgetCodes = new HashSet();
        HashSet termailCodes = new HashSet();
        HashSet personIds = new HashSet();
        data.forEach((index, item) -> {
            try {
                this.validateData((AuditExecuteIndicatorImportVo)item, formatMap, unitMap, personMap, cusCodes, typeCodes, formCodes, spCodes, detailPlanItemCodes, terChannelCodes, brandCodes, proItemCodes, productCodes, budgetCodes, termailCodes, personIds, subDetailPlanItemCodes, (Integer)index, resultErrorMap);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                String msg = "\u7b2c\u3010" + index + "\u3011\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                resultErrorMap.put((Integer)index, msg);
            }
        });
        List cusList = Lists.partition(new ArrayList(cusCodes), (int)500);
        Map cusMap = this.customerVoService.getCustomerByCodes(cusList);
        HashMap<String, Map<String, ActivityTypeRelationDetailVo>> typeMap = new HashMap();
        if (!typeCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(typeList = this.activityTypeService.getRelationDetailByTypeCodes(new ArrayList(typeCodes))))) {
            typeMap = typeList.stream().collect(Collectors.groupingBy(ActivityTypeRelationDetailVo::getActivityTypeCode, Collectors.toMap(ActivityTypeRelationDetailVo::getBusinessUnitCode, Function.identity())));
        }
        HashMap<String, ActivityFormVo> formMap = new HashMap();
        if (!formCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(formList = this.activityFormService.findActivityFormByCode(formCodes)))) {
            formMap = formList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        HashMap<String, ActivityTypeFormDetailVo> spMap = new HashMap();
        if (!spCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(spList = this.activityTypeService.getTypeFormBySplicingCodes(new ArrayList(spCodes))))) {
            spMap = spList.stream().collect(Collectors.toMap(ActivityTypeFormDetailVo::getSplicingCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        HashMap<String, ActivityDetailPlanItemVo> detailPlanItemMap = new HashMap();
        if (!detailPlanItemCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(itemVos3 = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes(detailPlanItemCodes, null)))) {
            detailPlanItemMap = itemVos3.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        HashMap<String, SubComActivityDetailPlanItemVo> subDetailPlanItemMap = new HashMap();
        if (!subDetailPlanItemCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(itemVos2 = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(new ArrayList(subDetailPlanItemCodes))))) {
            subDetailPlanItemMap = itemVos2.stream().collect(Collectors.toMap(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        HashMap<String, String> terChannelMap = new HashMap();
        if (!terChannelCodes.isEmpty()) {
            terChannelMap = this.mdmTerminalChannelVoService.findNameByCodes(new ArrayList(terChannelCodes));
        }
        HashMap<String, String> brandMap = new HashMap();
        if (!brandCodes.isEmpty()) {
            brandMap = this.productBrandService.findNameByCodeList(new ArrayList(brandCodes));
        }
        HashMap<String, String> proItemMap = new HashMap();
        if (!proItemCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(levelVos = this.productLevelVoSdkService.findListByCodes(new ArrayList(proItemCodes))))) {
            proItemMap = levelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (oldForm, newForm) -> newForm));
        }
        HashMap<String, ProductVo> productVoMap = new HashMap();
        if (!productCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(productVos = this.productVoService.findByCodes(new ArrayList(productCodes))))) {
            productVoMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        HashMap<String, BudgetItemVo> budgetMap = new HashMap();
        if (!budgetCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(itemVos = this.budgetItemService.listByCodes(new ArrayList(budgetCodes))))) {
            budgetMap = itemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        HashMap<String, TerminalVo> termialMap = new HashMap();
        if (!termailCodes.isEmpty() && !CollectionUtils.isEmpty((Collection)(terminalVos = this.terminalVoService.findBaseByTerminalCodes(new ArrayList(termailCodes))))) {
            termialMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (oldForm, newForm) -> newForm));
        }
        Map<String, Object> personIdMap = new HashMap<String, PromotersVo>();
        if (!personIds.isEmpty() && !CollectionUtils.isEmpty((Collection)(promotersVos = this.promotersVoService.findByIdCard(new ArrayList(personIds))))) {
            personIdMap = promotersVos.stream().collect(Collectors.toMap(PromotersVo::getIdentityCard, Function.identity(), (oldForm, newForm) -> newForm));
        }
        this.validateCorrect(data, cusMap, typeMap, formMap, spMap, detailPlanItemMap, terChannelMap, brandMap, proItemMap, productVoMap, budgetMap, termialMap, personIdMap, subDetailPlanItemMap, resultErrorMap);
    }

    private void validateData(AuditExecuteIndicatorImportVo dto, Map<String, String> formatMap, Map<String, String> unitMap, Map<String, String> personMap, Set<String> cusCodes, Set<String> typeCodes, Set<String> formCodes, Set<String> spCodes, Set<String> detailPlanItemCodes, Set<String> terChannelCodes, Set<String> brandCodes, Set<String> proItemCodes, Set<String> productCodes, Set<String> budgetCodes, Set<String> termailCodes, Set<String> personIds, Set<String> subDetailPlanItemCodes, Integer rowNum, Map<Integer, String> errMap) {
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getYearAndMonthStr()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getVariableCode()), "\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getIndicatorName()), "\u6267\u884c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getIndicatorValueStr()), "\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
        }
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
        }
        try {
            Date date = DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr().trim());
            this.validateIsTrue(dto.getYearAndMonthStr().trim().equals(DateUtil.date_yyyy_MM.format(date)), "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
            dto.setYearAndMonth(date);
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIndicatorValueStr())) {
            try {
                dto.setIndicatorValue(new BigDecimal(dto.getIndicatorValueStr()));
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u6307\u6807\u503c(\u6570\u5b57)\u5fc5\u987b\u662f\u6570\u5b57!");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActivityBeginDate())) {
            try {
                DateUtil.date_yyyy_MM_dd.parse(dto.getActivityBeginDate());
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM-dd\u3011");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActivityEndDate())) {
            try {
                DateUtil.date_yyyy_MM_dd.parse(dto.getActivityEndDate());
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM-dd\u3011");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPersonnelType())) {
            if (personMap.containsKey(dto.getPersonnelType())) {
                dto.setPersonnelType(personMap.get(dto.getPersonnelType()));
            } else {
                this.validateIsTrue(false, "\u4eba\u5458\u7c7b\u578b\u672a\u80fd\u8bc6\u522b");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActivityTypeCode())) {
            typeCodes.add(dto.getActivityTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActivityFormCode())) {
            formCodes.add(dto.getActivityFormCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActivityTypeCode()) && StringUtils.isNotBlank((CharSequence)dto.getActivityFormCode())) {
            spCodes.add(dto.getActivityTypeCode() + "-" + dto.getActivityFormCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActiveNumber())) {
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                subDetailPlanItemCodes.add(dto.getActiveNumber());
            } else {
                detailPlanItemCodes.add(dto.getActiveNumber());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getFirstChannelCode())) {
            terChannelCodes.add(dto.getFirstChannelCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSecondChannelCode())) {
            terChannelCodes.add(dto.getSecondChannelCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductBrandCode())) {
            brandCodes.add(dto.getProductBrandCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductCategoryCode())) {
            proItemCodes.add(dto.getProductCategoryCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductItemCode())) {
            proItemCodes.add(dto.getProductItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductCode())) {
            productCodes.add(dto.getProductCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getHeadBudgetItemCode())) {
            budgetCodes.add(dto.getHeadBudgetItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getMonthBudgetCode())) {
            budgetCodes.add(dto.getMonthBudgetCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStoresCode())) {
            termailCodes.add(dto.getStoresCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPersonIdCard())) {
            personIds.add(dto.getPersonIdCard());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIsTemporary())) {
            this.validateIsTrue(BooleanEnum.TRUE.getSure().equals(dto.getIsTemporary()) || BooleanEnum.FALSE.getSure().equals(dto.getIsTemporary()), "\u662f\u5426\u4e34\u65f6\u6d3b\u52a8\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u586b\u5199\u662f\u6216\u5426 ");
        }
        dto.setDockingSystem("TPM");
        cusCodes.add(dto.getCustomerCode() + dto.getSalesInstitutionCode() + dto.getChannelCode() + dto.getBusinessFormatCode());
        String errInfo = this.validateGetErrorInfo();
        if (errInfo != null) {
            errMap.put(rowNum, errInfo);
        }
    }

    private void validateCorrect(LinkedHashMap<Integer, AuditExecuteIndicatorImportVo> data, Map<String, CustomerOrgChannelStoresVo> cusMap, Map<String, Map<String, ActivityTypeRelationDetailVo>> typeMap, Map<String, ActivityFormVo> formMap, Map<String, ActivityTypeFormDetailVo> spMap, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, Map<String, String> terChannelMap, Map<String, String> brandMap, Map<String, String> proItemMap, Map<String, ProductVo> productVoMap, Map<String, BudgetItemVo> budgetMap, Map<String, TerminalVo> termialMap, Map<String, PromotersVo> personIdMap, Map<String, SubComActivityDetailPlanItemVo> subDetailPlanItemMap, Map<Integer, String> resultErrorMap) {
        Map<Object, Object> varMap = new HashMap();
        Map<Object, Object> customVarMap = new HashMap();
        try {
            varMap = this.registerList.stream().collect(Collectors.toMap(FormulaVariableRegister::getVariableCode, FormulaVariableRegister::getVariableName));
            List cusVarList = this.sourceCustomVariableService.findAllVariableList();
            if (!CollectionUtils.isEmpty((Collection)cusVarList)) {
                customVarMap = cusVarList.stream().collect(Collectors.toMap(RegisterVariableVo::getCode, RegisterVariableVo::getName, (oldV, newV) -> newV));
            }
        }
        catch (Exception e) {
            log.error("\u53d8\u91cf\u8f6c\u6362map\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
        ArrayList<String> onlyKeys = new ArrayList<String>();
        for (Map.Entry<Integer, AuditExecuteIndicatorImportVo> entry : data.entrySet()) {
            AuditExecuteIndicatorImportVo dto2 = entry.getValue();
            int index = entry.getKey();
            try {
                Set buSet;
                Set bfSet;
                BudgetItemVo budgetItemVo;
                String cusKey = dto2.getCustomerCode() + dto2.getSalesInstitutionCode() + dto2.getChannelCode() + dto2.getBusinessFormatCode();
                if (!cusMap.containsKey(cusKey)) {
                    this.validateIsTrue(false, "\u6839\u636e\u5ba2\u6237\u7f16\u7801\u672a\u80fd\u67e5\u627e\u5230\u5ba2\u6237\u4fe1\u606f");
                } else {
                    CustomerOrgChannelStoresVo cVo = cusMap.get(cusKey);
                    dto2.setCustomerCode(cVo.getCustomerCode());
                    dto2.setCustomerName(cVo.getCustomerName());
                    dto2.setCustomerErpCode(cVo.getErpCode());
                    dto2.setSalesInstitutionCode(cVo.getSalesInstitutionCode());
                    dto2.setSalesInstitutionName(cVo.getSalesInstitutionName());
                    dto2.setSalesInstitutionErpCode(cVo.getSalesInstitutionErpCode());
                    dto2.setSalesRegionCode(cVo.getSalesRegionCode());
                    dto2.setSalesRegionName(cVo.getSalesRegionName());
                    dto2.setSalesRegionErpCode(cVo.getSalesRegionErpCode());
                    dto2.setSalesOrgCode(cVo.getSalesOrgCode());
                    dto2.setSalesOrgName(cVo.getSalesOrgName());
                    dto2.setSalesOrgErpCode(cVo.getSalesOrgErpCode());
                    if (cVo.getChannelCode().equals(dto2.getChannelCode())) {
                        dto2.setChannelName(cVo.getChannelName());
                    } else {
                        this.validateIsTrue(false, "\u6b64\u5ba2\u6237\u672a\u7ed1\u5b9a\u6b64\u6e20\u9053");
                    }
                }
                if (!varMap.containsKey(dto2.getVariableCode()) && !customVarMap.containsKey(dto2.getVariableCode())) {
                    this.validateIsTrue(false, "\u6839\u636e\u6307\u6807\u7f16\u7801\u672a\u80fd\u67e5\u627e\u5230\u6307\u6807\u4fe1\u606f");
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getActivityTypeCode())) {
                    this.validateIsTrue(typeMap.containsKey(dto2.getActivityTypeCode()), "\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5206\u7c7b");
                    Map tMap = typeMap.getOrDefault(dto2.getActivityTypeCode(), new HashMap());
                    this.validateIsTrue(tMap.containsKey(dto2.getBusinessUnitCode()), "\u6b64\u6d3b\u52a8\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u52a1\u5355\u5143");
                    if (tMap.containsKey(dto2.getBusinessUnitCode())) {
                        ActivityTypeRelationDetailVo detailVo = tMap.getOrDefault(dto2.getBusinessUnitCode(), new ActivityTypeRelationDetailVo());
                        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)detailVo.getBusinessFormatCode()), "\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5206\u7c7b\u7684\u4e1a\u6001");
                        this.validateIsTrue(detailVo.getBusinessFormatCode().equals(dto2.getBusinessFormatCode()), "\u6b64\u6d3b\u52a8\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001");
                        dto2.setActivityTypeName(detailVo.getActivityTypeName());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getActivityFormCode())) {
                    this.validateIsTrue(formMap.containsKey(dto2.getActivityFormCode()), "\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5f62\u5f0f");
                    ActivityFormVo form = formMap.getOrDefault(dto2.getActivityFormCode(), new ActivityFormVo());
                    if (formMap.containsKey(dto2.getActivityFormCode())) {
                        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)form.getBusinessFormatCode()), "\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5f62\u5f0f\u7684\u4e1a\u6001");
                        this.validateIsTrue(form.getBusinessFormatCode().equals(dto2.getBusinessFormatCode()), "\u6b64\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001");
                        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)form.getBusinessUnitCode()), "\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5f62\u5f0f\u7684\u4e1a\u52a1\u5355\u5143");
                        this.validateIsTrue(form.getBusinessUnitCode().equals(dto2.getBusinessUnitCode()), "\u6b64\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u52a1\u5355\u5143");
                        dto2.setActivityFormName(form.getActivityFormName());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getActivityTypeCode()) && StringUtils.isNotBlank((CharSequence)dto2.getActivityFormCode())) {
                    String spCode = dto2.getActivityTypeCode() + "-" + dto2.getActivityFormCode();
                    this.validateIsTrue(spMap.containsKey(spCode), "\u6b64\u6d3b\u52a8\u5206\u7c7b\u672a\u5173\u8054\u6b64\u6d3b\u52a8\u5f62\u5f0f");
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getActiveNumber())) {
                    this.validateIsTrue(detailPlanItemMap.containsKey(dto2.getActiveNumber()), "\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6");
                    ActivityDetailPlanItemVo detailPlanItemVo = detailPlanItemMap.getOrDefault(dto2.getActiveNumber(), new ActivityDetailPlanItemVo());
                    if (detailPlanItemMap.containsKey(dto2.getActiveNumber())) {
                        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)detailPlanItemVo.getBusinessFormatCode()) && detailPlanItemVo.getBusinessFormatCode().equals(dto2.getBusinessFormatCode()), "\u6b64\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001");
                        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)detailPlanItemVo.getBusinessUnitCode()) && detailPlanItemVo.getBusinessUnitCode().equals(dto2.getBusinessUnitCode()), "\u6b64\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u52a1\u5355\u5143");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getFirstChannelCode())) {
                    if (terChannelMap.containsKey(dto2.getFirstChannelCode())) {
                        dto2.setFirstChannelName(terChannelMap.get(dto2.getFirstChannelCode()));
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u4e00\u7ea7\u6e20\u9053");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getSecondChannelCode())) {
                    if (terChannelMap.containsKey(dto2.getSecondChannelCode())) {
                        dto2.setSecondChannelName(terChannelMap.get(dto2.getSecondChannelCode()));
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u4e8c\u7ea7\u6e20\u9053");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getProductBrandCode())) {
                    if (brandMap.containsKey(dto2.getProductBrandCode())) {
                        dto2.setProductBrandName(brandMap.get(dto2.getProductBrandCode()));
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u54c1\u724c");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getProductCategoryCode())) {
                    if (proItemMap.containsKey(dto2.getProductCategoryCode())) {
                        dto2.setProductCategoryName(proItemMap.get(dto2.getProductCategoryCode()));
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u54c1\u7c7b");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getProductItemCode())) {
                    if (proItemMap.containsKey(dto2.getProductItemCode())) {
                        dto2.setProductItemName(proItemMap.get(dto2.getProductItemCode()));
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u54c1\u9879");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getProductCode())) {
                    if (productVoMap.containsKey(dto2.getProductCode())) {
                        ProductVo productVo = productVoMap.get(dto2.getProductCode());
                        dto2.setProductBrandCode(productVo.getProductBrandCode());
                        dto2.setProductCategoryCode(productVo.getProductCategoryCode());
                        dto2.setProductItemCode(productVo.getProductLevelCode());
                        dto2.setProductName(productVo.getProductName());
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u4ea7\u54c1");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getHeadBudgetItemCode())) {
                    if (budgetMap.containsKey(dto2.getHeadBudgetItemCode())) {
                        budgetItemVo = budgetMap.get(dto2.getHeadBudgetItemCode());
                        this.validateIsTrue(!CollectionUtils.isEmpty((Collection)budgetItemVo.getControlConditionDtoList()), "\u6b64\u603b\u90e8\u7edf\u7b79\u9884\u7b97\u9879\u76ee\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001\u4e1a\u52a1\u5355\u5143");
                        bfSet = budgetItemVo.getControlConditionDtoList().stream().map(BudgetItemControlConditionVo::getBusinessFormatCode).collect(Collectors.toSet());
                        buSet = budgetItemVo.getControlConditionDtoList().stream().map(BudgetItemControlConditionVo::getBusinessUnitCode).collect(Collectors.toSet());
                        this.validateIsTrue(!bfSet.isEmpty() && bfSet.contains(dto2.getBusinessFormatCode()), "\u6b64\u603b\u90e8\u7edf\u7b79\u9884\u7b97\u9879\u76ee\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001");
                        this.validateIsTrue(!buSet.isEmpty() && buSet.contains(dto2.getBusinessUnitCode()), "\u6b64\u603b\u90e8\u7edf\u7b79\u9884\u7b97\u9879\u76ee\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u52a1\u5355\u5143");
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u603b\u90e8\u7edf\u7b79\u9884\u7b97\u9879\u76ee");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getMonthBudgetCode())) {
                    if (budgetMap.containsKey(dto2.getMonthBudgetCode())) {
                        budgetItemVo = budgetMap.get(dto2.getMonthBudgetCode());
                        this.validateIsTrue(!CollectionUtils.isEmpty((Collection)budgetItemVo.getControlConditionDtoList()), "\u6b64\u5927\u533a\u9884\u7b97\u9879\u76ee\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001\u4e1a\u52a1\u5355\u5143");
                        bfSet = budgetItemVo.getControlConditionDtoList().stream().map(BudgetItemControlConditionVo::getBusinessFormatCode).collect(Collectors.toSet());
                        buSet = budgetItemVo.getControlConditionDtoList().stream().map(BudgetItemControlConditionVo::getBusinessUnitCode).collect(Collectors.toSet());
                        this.validateIsTrue(!bfSet.isEmpty() && bfSet.contains(dto2.getBusinessFormatCode()), "\u6b64\u5927\u533a\u9884\u7b97\u9879\u76ee\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u6001");
                        this.validateIsTrue(!buSet.isEmpty() && buSet.contains(dto2.getBusinessUnitCode()), "\u6b64\u5927\u533a\u9884\u7b97\u9879\u76ee\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e1a\u52a1\u5355\u5143");
                    } else {
                        this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u6b64\u5927\u533a\u9884\u7b97\u9879\u76ee");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getStoresCode()) && termialMap.containsKey(dto2.getStoresCode())) {
                    dto2.setStoresName(termialMap.get(dto2.getStoresCode()).getTerminalName());
                }
                if (StringUtils.isNotBlank((CharSequence)dto2.getPersonIdCard()) && personIdMap.containsKey(dto2.getPersonIdCard())) {
                    PromotersVo promotersVo = personIdMap.get(dto2.getPersonIdCard());
                    dto2.setPersonCode(promotersVo.getEmployeeCode());
                    dto2.setPersonName(promotersVo.getName());
                }
                dto2.setIndicatorName(dto2.getVariableCode());
                String onlyKey = dto2.getBusinessFormatCode() + dto2.getBusinessUnitCode() + DateUtil.dateToStr((Date)dto2.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + dto2.getCustomerCode() + dto2.getVariableCode();
                if (StringUtils.isNotBlank((CharSequence)dto2.getStoresCode())) {
                    onlyKey = onlyKey + dto2.getStoresCode();
                }
                onlyKeys.add(onlyKey);
                String errInfo = this.validateGetErrorInfo();
                if (errInfo == null) continue;
                resultErrorMap.put(index, errInfo);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                String msg = "\u7b2c\u3010" + index + "\u3011\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                resultErrorMap.put(index, msg);
                return;
            }
        }
        Map oldMap = this.auditExecuteIndicatorService.findByOnlyKeys(onlyKeys);
        data.forEach((k, dto) -> {
            String onlyKey = dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + DateUtil.dateToStr((Date)dto.getYearAndMonth(), (SimpleDateFormat)DateUtil.date_yyyy_MM) + dto.getCustomerCode() + dto.getVariableCode();
            if (StringUtils.isNotBlank((CharSequence)dto.getStoresCode())) {
                onlyKey = onlyKey + dto.getStoresCode();
            }
            if (oldMap.containsKey(onlyKey)) {
                dto.setId((String)oldMap.get(onlyKey));
            }
        });
    }

    public Class<AuditExecuteIndicatorImportVo> findCrmExcelVoClass() {
        return AuditExecuteIndicatorImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868";
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_ONE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868-\u4e3b\u4f53";
    }
}

