/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.alibaba.excel.util.Validate;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorSapImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditExecuteIndicatorSapImportProcess
implements ImportProcess<AuditExecuteIndicatorSapImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteIndicatorSapImportProcess.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;

    public Integer getBatchCount() {
        return 5000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, AuditExecuteIndicatorSapImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, AuditExecuteIndicatorSapImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            AuditExecuteIndicatorSapImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getYearAndMonthStr()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getIndicatorName()), "\u6267\u884c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(vo.getIndicatorValue() != null, "\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditExecuteIndicatorSapImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap errMap = new HashMap();
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e00\u6b65");
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        List<AuditExecuteIndicatorDto> importList = this.validate(data, resultErrorMap);
        if (!resultErrorMap.isEmpty()) {
            return resultErrorMap;
        }
        this.auditExecuteIndicatorService.bulkImportSave(importList);
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e8c\u6b65");
        return null;
    }

    private List<AuditExecuteIndicatorDto> validate(LinkedHashMap<Integer, AuditExecuteIndicatorSapImportVo> data, Map<Integer, String> resultErrorMap) {
        ArrayList<AuditExecuteIndicatorSapImportVo> importList = new ArrayList<AuditExecuteIndicatorSapImportVo>(data.values());
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Map regionMap = this.dictToolkitService.findConvertMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)regionMap), (String)"\u672a\u67e5\u8be2\u5230\u96f6\u552e\u5546\u533a\u57df\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map indicatorsMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_implementation_indicators");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)indicatorsMap), (String)"\u672a\u67e5\u8be2\u5230\u6267\u884c\u6307\u6807\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        int i = 1;
        for (AuditExecuteIndicatorSapImportVo item : importList) {
            ++i;
            try {
                this.validateData(item, formatMap, unitMap, regionMap, indicatorsMap, resultErrorMap, i);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                String msg = "\u7b2c\u3010" + i + "\u3011\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                resultErrorMap.put(i, msg);
                return new ArrayList<AuditExecuteIndicatorDto>();
            }
        }
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(importList, AuditExecuteIndicatorSapImportVo.class, AuditExecuteIndicatorDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<AuditExecuteIndicatorDto>(dtoList);
    }

    private void validateData(AuditExecuteIndicatorSapImportVo dto, Map<String, String> formatMap, Map<String, String> unitMap, Map<String, String> regionMap, Map<String, String> indicatorsMap, Map<Integer, String> errMap, Integer rowNum) {
        String errInfo;
        String retailerName;
        String regionName;
        String customerCode;
        String employeeCode = indicatorsMap.get(dto.getIndicatorName());
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)employeeCode), (String)("\u6267\u884c\u6307\u6807\u540d\u79f0:" + dto.getIndicatorName() + "\u672a\u5339\u914d\u5230\u6267\u884c\u6307\u6807\u7f16\u7801!"), (Object[])new Object[0]);
        dto.setIndicatorName(employeeCode);
        String salesInstitutionCode = dto.getSalesInstitutionCode();
        if (StringUtils.isNotBlank((CharSequence)salesInstitutionCode)) {
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(salesInstitutionCode);
            if (salesOrgVo != null) {
                dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            } else {
                this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801" + salesInstitutionCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(customerCode = dto.getCustomerCode())) && StringUtils.isEmpty((CharSequence)dto.getCustomerName())) {
            ArrayList<String> codes = new ArrayList<String>(1);
            codes.add(customerCode);
            List baseByCustomerCodes = this.customerVoService.findBaseByCustomerCodes(codes);
            if (CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes) && baseByCustomerCodes.size() > 0) {
                dto.setCustomerName(((CustomerVo)baseByCustomerCodes.get(0)).getCustomerName());
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801" + customerCode + "\u4e3a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(regionName = dto.getRegionName()))) {
            String regionCode = regionMap.get(regionName);
            if (StringUtils.isNotBlank((CharSequence)regionCode)) {
                dto.setRegionCode(regionCode);
            } else {
                this.validateIsTrue(false, "\u6240\u5c5e\u5927\u533a\u540d\u79f0:" + regionName + "\u672a\u5339\u914d\u5230\u6240\u5c5e\u5927\u533a\u7f16\u7801!");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(retailerName = dto.getCustomerRetailerName()))) {
            List customerRetailerVoList = this.customerRetailerVoService.findByName(retailerName);
            if (CollectionUtils.isNotEmpty((Collection)customerRetailerVoList)) {
                if (customerRetailerVoList.size() == 1) {
                    dto.setCustomerRetailerCode((String)customerRetailerVoList.get(0));
                } else {
                    this.validateIsTrue(false, "\u6240\u5c5e\u96f6\u552e\u5546\u540d\u79f0:" + regionName + "\u5339\u914d\u5230\u6240\u5c5e\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u6b62\u4e00\u4e2a!");
                }
            } else {
                this.validateIsTrue(false, "\u6240\u5c5e\u96f6\u552e\u5546\u540d\u79f0:" + regionName + "\u672a\u5339\u914d\u5230\u6240\u5c5e\u96f6\u552e\u5546\u7f16\u7801!");
            }
        }
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
        }
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
        }
        try {
            dto.setYearAndMonth(DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr()));
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        dto.setDockingSystem("SAP");
        String productBrandCode = dto.getProductBrandCode();
        String productCategoryCode = dto.getProductCategoryCode();
        String productItemCode = dto.getProductItemCode();
        String productCode = dto.getProductCode();
        if (StringUtils.isNotBlank((CharSequence)productBrandCode)) {
            ArrayList<String> productBrandCodes = new ArrayList<String>(1);
            productBrandCodes.add(productBrandCode);
            List productBrandVos = this.productBrandService.listByCodes(productBrandCodes);
            if (CollectionUtils.isNotEmpty((Collection)productBrandVos) && productBrandVos.size() > 0) {
                dto.setProductName(((ProductBrandVo)productBrandVos.get(0)).getProductBrandName());
            } else {
                this.validateIsTrue(false, "\u54c1\u724c\u7f16\u7801" + productBrandCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)productCategoryCode)) {
            ArrayList<String> productCategoryCodes = new ArrayList<String>(1);
            productCategoryCodes.add(productCategoryCode);
            List listByCodes = this.productLevelVoSdkService.findListByCodes(productCategoryCodes);
            if (CollectionUtils.isNotEmpty((Collection)listByCodes) && listByCodes.size() > 0) {
                dto.setProductCategoryName(((ProductLevelVo)listByCodes.get(0)).getProductLevelName());
            } else {
                this.validateIsTrue(false, "\u54c1\u7c7b\u7f16\u7801" + productCategoryCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)productItemCode)) {
            ArrayList<String> productItemCodes = new ArrayList<String>(1);
            productItemCodes.add(productCategoryCode);
            List listByProductItemCodes = this.productLevelVoSdkService.findListByCodes(productItemCodes);
            if (CollectionUtils.isNotEmpty((Collection)listByProductItemCodes) && listByProductItemCodes.size() > 0) {
                dto.setProductCategoryName(((ProductLevelVo)listByProductItemCodes.get(0)).getProductLevelName());
            } else {
                this.validateIsTrue(false, "\u54c1\u7c7b\u7f16\u7801" + productCategoryCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)productCode)) {
            ArrayList<String> productCodes = new ArrayList<String>(1);
            productCodes.add(productCode);
            List byProductCodes = this.productVoService.findByCodes(productCodes);
            if (CollectionUtils.isNotEmpty((Collection)byProductCodes) && byProductCodes.size() > 0) {
                dto.setProductName(((ProductVo)byProductCodes.get(0)).getProductName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801" + productCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getActiveNumber())) {
            List itemList;
            ArrayList<String> itemCodes;
            if (dto.getActiveNumber().startsWith("P")) {
                itemCodes = new ArrayList<String>(1);
                itemCodes.add(dto.getActiveNumber());
                itemList = this.subComActivityDesignDetailService.findDetailByDetailCodes(itemCodes);
                if (CollectionUtils.isNotEmpty((Collection)itemList) && itemList.size() > 0) {
                    SubComActivityDesignDetailVo itemVo = (SubComActivityDesignDetailVo)itemList.get(0);
                    if (StringUtils.isBlank((CharSequence)dto.getSalesInstitutionCode())) {
                        dto.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
                        dto.setSalesInstitutionName(itemVo.getSalesInstitutionName());
                        dto.setSalesRegionCode(itemVo.getSalesOrgCode());
                        dto.setSalesRegionName(itemVo.getSalesOrgName());
                        dto.setSalesOrgCode(itemVo.getSalesGroupCode());
                        dto.setSalesOrgName(itemVo.getSalesGroupName());
                    }
                    dto.setChannelCode(itemVo.getDistributionChannelCode());
                    dto.setChannelName(itemVo.getDistributionChannelName());
                    if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
                        dto.setCustomerCode(itemVo.getCustomerCode());
                        dto.setCustomerName(itemVo.getCustomerName());
                    }
                    dto.setStoresCode(itemVo.getTerminalCode());
                    dto.setStoresName(itemVo.getTerminalName());
                    dto.setPersonnelType(itemVo.getPersonType());
                    dto.setPersonnelId(itemVo.getPersonCode());
                    try {
                        dto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)itemVo.getActivityBeginTime()));
                        dto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)itemVo.getActivityEndTime()));
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductBrandCode())) {
                        dto.setProductBrandCode(itemVo.getProductBrandCode());
                        dto.setProductBrandName(itemVo.getProductBrandName());
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductCategoryCode())) {
                        dto.setProductCategoryCode(itemVo.getProductCategoryCode());
                        dto.setProductCategoryName(itemVo.getProductCategoryName());
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductItemCode())) {
                        dto.setProductItemCode(itemVo.getProductItemCode());
                        dto.setProductItemName(itemVo.getProductItemName());
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductCode())) {
                        dto.setProductCode(itemVo.getProductCode());
                        dto.setProductName(itemVo.getProductName());
                    }
                    dto.setActivityFormCode(itemVo.getActivityFormCode());
                    dto.setActivityFormName(itemVo.getActivityFormName());
                    dto.setActivityTypeCode(itemVo.getActivityTypeCode());
                    dto.setActivityTypeName(itemVo.getActivityTypeName());
                } else {
                    this.validateIsTrue(false, "\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801" + dto.getActiveNumber() + "\u672a\u5339\u914d\u5230\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else if (dto.getActiveNumber().startsWith("Z")) {
                itemCodes = new ArrayList(1);
                itemCodes.add(dto.getActiveNumber());
                itemList = this.activityDetailPlanItemService.findByItemCodes(itemCodes);
                if (CollectionUtils.isNotEmpty((Collection)itemList) && itemList.size() > 0) {
                    ActivityDetailPlanItemVo itemVo = (ActivityDetailPlanItemVo)itemList.get(0);
                    if (StringUtils.isBlank((CharSequence)dto.getSalesInstitutionCode())) {
                        dto.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
                        dto.setSalesInstitutionName(itemVo.getSalesInstitutionName());
                        dto.setSalesRegionCode(itemVo.getSalesRegionCode());
                        dto.setSalesRegionName(itemVo.getSalesRegionName());
                        dto.setSalesOrgCode(itemVo.getSalesOrgCode());
                        dto.setSalesOrgName(itemVo.getSalesOrgName());
                    }
                    dto.setChannelCode(itemVo.getDistributionChannelCode());
                    dto.setChannelName(itemVo.getDistributionChannelName());
                    if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
                        dto.setCustomerCode(itemVo.getCustomerCode());
                        dto.setCustomerName(itemVo.getCustomerName());
                    }
                    dto.setStoresCode(itemVo.getTerminalCode());
                    dto.setStoresName(itemVo.getTerminalName());
                    dto.setPersonnelType(itemVo.getPersonType());
                    dto.setPersonnelId(itemVo.getPersonCode());
                    try {
                        dto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)itemVo.getActivityBeginDate()));
                        dto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)itemVo.getActivityEndDate()));
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductBrandCode())) {
                        dto.setProductBrandCode(itemVo.getProductBrandCode());
                        dto.setProductBrandName(itemVo.getProductBrandName());
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductCategoryCode())) {
                        dto.setProductCategoryCode(itemVo.getProductCategoryCode());
                        dto.setProductCategoryName(itemVo.getProductCategoryName());
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductItemCode())) {
                        dto.setProductItemCode(itemVo.getProductItemCode());
                        dto.setProductItemName(itemVo.getProductItemName());
                    }
                    if (StringUtils.isBlank((CharSequence)dto.getProductCode())) {
                        dto.setProductCode(itemVo.getProductCode());
                        dto.setProductName(itemVo.getProductName());
                    }
                    dto.setActivityFormCode(itemVo.getActivityFormCode());
                    dto.setActivityFormName(itemVo.getActivityFormName());
                    dto.setActivityTypeCode(itemVo.getActivityTypeCode());
                    dto.setActivityTypeName(itemVo.getActivityTypeName());
                } else {
                    this.validateIsTrue(false, "\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801" + dto.getActiveNumber() + "\u672a\u5339\u914d\u5230\u7ec6\u6848\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
        }
        if ((errInfo = this.validateGetErrorInfo()) != null) {
            errMap.put(rowNum, errInfo);
        }
    }

    public Class<AuditExecuteIndicatorSapImportVo> findCrmExcelVoClass() {
        return AuditExecuteIndicatorSapImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868";
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_SAP_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868-SAP\u53d1\u751f";
    }
}

