/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.repository.AuditExecuteIndicatorRepository;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.AuditExecuteIndicatorLogService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorLogEventDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.log.AuditExecuteIndicatorEventListener;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.SapActivityExecution;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorOnlyKeyVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorSdkVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="auditExecuteIndicatorService")
public class AuditExecuteIndicatorServiceImpl
implements AuditExecuteIndicatorService {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteIndicatorServiceImpl.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorRepository auditExecuteIndicatorRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SapActivityExecution sapActivityExecution;
    @Autowired(required=false)
    private AuditExecuteIndicatorLogService auditExecuteIndicatorLogService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Page<AuditExecuteIndicatorVo> findByConditions(Pageable pageable, AuditExecuteIndicatorDto auditExecuteIndicatorDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(auditExecuteIndicatorDto)) {
            auditExecuteIndicatorDto = new AuditExecuteIndicatorDto();
        }
        return this.auditExecuteIndicatorRepository.findByConditions(pageable, auditExecuteIndicatorDto);
    }

    public AuditExecuteIndicatorVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditExecuteIndicator invoice = (AuditExecuteIndicator)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditExecuteIndicatorRepository.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        if (null == invoice) {
            return null;
        }
        return (AuditExecuteIndicatorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoice, AuditExecuteIndicatorVo.class, null, null, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(AuditExecuteIndicatorDto dto) {
        this.updateValidate(dto);
        AuditExecuteIndicatorVo oldVo = this.findById(dto.getId());
        Validate.notNull((Object)oldVo, (String)"\u672a\u67e5\u627e\u5230\u6307\u6807\u6570\u636e", (Object[])new Object[0]);
        AuditExecuteIndicator indicator = (AuditExecuteIndicator)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditExecuteIndicator.class, null, null, new String[0]));
        this.auditExecuteIndicatorRepository.updateByIdAndTenantCode(indicator, TenantUtils.getTenantCode());
        AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = AuditExecuteIndicatorEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteIndicatorEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    private void updateValidate(AuditExecuteIndicatorDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getYearAndMonth(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getChannelCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getChannelName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dto.getStoresCode())) {
            dto.setStoresCode("");
        }
        if (StringUtils.isBlank((CharSequence)dto.getStoresName())) {
            dto.setStoresName("");
        }
        Validate.notBlank((CharSequence)dto.getIndicatorCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getIndicatorName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getIndicatorValue(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List rulesList = this.auditExecuteIndicatorRepository.listByIds(idList);
        ArrayList executeIndicators = new ArrayList();
        rulesList.forEach(item -> {
            AuditExecuteIndicator indicator = new AuditExecuteIndicator();
            indicator.setId(item.getId());
            indicator.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            executeIndicators.add(indicator);
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            AuditExecuteIndicatorVo oldVo = (AuditExecuteIndicatorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            AuditExecuteIndicatorDto newDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorDto.class, null, null, new String[0]);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDelete = AuditExecuteIndicatorEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteIndicatorEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.auditExecuteIndicatorRepository.updateBatchById(executeIndicators);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List activityApplyRuless = this.auditExecuteIndicatorRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityApplyRuless) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList executeIndicators = new ArrayList();
        activityApplyRuless.forEach(item -> {
            AuditExecuteIndicator indicator = new AuditExecuteIndicator();
            indicator.setId(item.getId());
            indicator.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            executeIndicators.add(indicator);
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            AuditExecuteIndicatorVo oldVo = (AuditExecuteIndicatorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            AuditExecuteIndicatorDto newDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = AuditExecuteIndicatorEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteIndicatorEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.auditExecuteIndicatorRepository.updateBatchById(executeIndicators);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List activityApplyRuless = this.auditExecuteIndicatorRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityApplyRuless) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList executeIndicators = new ArrayList();
        activityApplyRuless.forEach(item -> {
            AuditExecuteIndicator indicator = new AuditExecuteIndicator();
            indicator.setId(item.getId());
            indicator.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            executeIndicators.add(indicator);
            AuditExecuteIndicatorLogEventDto logEventDto = new AuditExecuteIndicatorLogEventDto();
            AuditExecuteIndicatorVo oldVo = (AuditExecuteIndicatorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            AuditExecuteIndicatorDto newDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDisable = AuditExecuteIndicatorEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteIndicatorEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.auditExecuteIndicatorRepository.updateBatchById(executeIndicators);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bulkImportSave(List<AuditExecuteIndicatorDto> importList) {
        try {
            if (CollectionUtils.isEmpty(importList)) {
                return;
            }
            AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
            Date date = new Date();
            ArrayList<AuditExecuteIndicatorDto> addList = new ArrayList<AuditExecuteIndicatorDto>();
            ArrayList<AuditExecuteIndicatorDto> editList = new ArrayList<AuditExecuteIndicatorDto>();
            for (AuditExecuteIndicatorDto dto : importList) {
                if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
                    dto.setModifyAccount(loginDetails.getUsername());
                    dto.setModifyName(loginDetails.getRealName());
                    dto.setModifyTime(date);
                    editList.add(dto);
                    continue;
                }
                dto.setCreateAccount(loginDetails.getUsername());
                dto.setCreateName(loginDetails.getRealName());
                dto.setCreateTime(date);
                dto.setTenantCode(loginDetails.getTenantCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                addList.add(dto);
            }
            if (!CollectionUtils.isEmpty(addList)) {
                int size;
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u65b0\u589e\u6570\u636e\u6761\u6570\uff1a{}", (Object)addList.size());
                List codes = this.generateCodeService.generateCode("ZXZB", addList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
                for (int i = 0; i < addList.size(); ++i) {
                    AuditExecuteIndicatorDto inDto = (AuditExecuteIndicatorDto)addList.get(i);
                    inDto.setIndicatorCode((String)codes.get(i));
                }
                addList.forEach(a -> a.setIndicatorValue(Optional.ofNullable(a.getIndicatorValue()).orElse(BigDecimal.ZERO)));
                Collection adds = this.nebulaToolkitService.copyCollectionByWhiteList(addList, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                List rateList = (List)adds;
                int partialLimit = 500;
                if (partialLimit < size) {
                    int start = 0;
                    for (size = rateList.size(); size > 0; size -= partialLimit) {
                        if (size < partialLimit) {
                            partialLimit = size;
                        }
                        List<AuditExecuteIndicator> partList = rateList.subList(start, partialLimit);
                        this.auditExecuteIndicatorRepository.bulkSave(partList);
                        partList.clear();
                    }
                } else {
                    this.auditExecuteIndicatorRepository.bulkSave(rateList);
                }
                rateList.clear();
            }
            ArrayList<AuditExecuteIndicatorLogEventDto> editLogs = new ArrayList<AuditExecuteIndicatorLogEventDto>();
            if (!CollectionUtils.isEmpty(editList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u7f16\u8f91\u6570\u636e\u6761\u6570\uff1a{}", (Object)editList.size());
                List rates = Lists.partition(editList, (int)500);
                for (List list : rates) {
                    List ids = list.stream().map(UuidDto::getId).collect(Collectors.toList());
                    List oldList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditExecuteIndicatorRepository.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
                    Collection oldDtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)oldList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    Map oldMap = oldDtoList.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
                    for (AuditExecuteIndicatorDto dto : list) {
                        AuditExecuteIndicatorLogEventDto eventDto = new AuditExecuteIndicatorLogEventDto();
                        eventDto.setNewest(dto);
                        eventDto.setOriginal(oldMap.getOrDefault(dto.getId(), new AuditExecuteIndicatorVo()));
                        editLogs.add(eventDto);
                    }
                    Collection res = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    this.auditExecuteIndicatorRepository.updateBatchByIdAndTenantCode(res, TenantUtils.getTenantCode());
                }
            }
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u65b0\u589e\u65e5\u5fd7");
                this.auditExecuteIndicatorLogService.addLogAsync(addList);
            }
            if (!CollectionUtils.isEmpty(editLogs)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u7f16\u8f91\u65e5\u5fd7");
                this.auditExecuteIndicatorLogService.updateLogAsync(editLogs);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new NullPointerException(e.getMessage());
        }
    }

    public List<AuditExecuteIndicatorVo> findListByCondition(AuditExecuteIndicatorDto dto) {
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findListByCondition(dto);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        Collection auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditExecuteIndicatorVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void bulkSaveOrUpdate(List<AuditExecuteIndicatorDto> saveList, List<AuditExecuteIndicatorDto> updateList) {
        List entyList;
        List indicators;
        if (!CollectionUtils.isEmpty(saveList)) {
            indicators = Lists.partition(saveList, (int)500);
            for (List list : indicators) {
                entyList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, HashSet.class, ArrayList.class, new String[0]);
                entyList.forEach(a -> a.setIndicatorValue(Optional.ofNullable(a.getIndicatorValue()).orElse(BigDecimal.ZERO)));
                this.auditExecuteIndicatorRepository.saveBatch(entyList);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            indicators = Lists.partition(updateList, (int)500);
            for (List list : indicators) {
                entyList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, HashSet.class, ArrayList.class, new String[0]);
                entyList.forEach(a -> a.setIndicatorValue(Optional.ofNullable(a.getIndicatorValue()).orElse(BigDecimal.ZERO)));
                this.auditExecuteIndicatorRepository.updateBatchById(entyList);
            }
        }
    }

    public void queryAllExecutionSapBranch() {
        this.sapActivityExecution.queryAllExecutionSapBranch();
    }

    public void queryExecutionSapBranch(String orgCode, String itemCode, String activityDate) {
        this.sapActivityExecution.queryExecutionSapBranch(orgCode, itemCode, activityDate);
    }

    public List<AuditExecuteIndicatorVo> findByCode(String activeNumber, String indicatorName) {
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findByCode(activeNumber, indicatorName);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        Collection auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditExecuteIndicatorVos;
    }

    public List<AuditExecuteIndicatorVo> findByCodeList(List<String> activeNumberList, String indicatorName) {
        List<AuditExecuteIndicatorVo> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findByCodeList(activeNumberList, indicatorName);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        return auditExecuteIndicatorList;
    }

    public List<AuditExecuteIndicatorVo> findData(AuditExecuteIndicatorDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findData(dto);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditExecuteIndicatorVo> findByActiveNumber(List<String> activeNumbers, String dockingSystem, String businessUnitCode) {
        if (CollectionUtils.isEmpty(activeNumbers) || StringUtils.isBlank((CharSequence)dockingSystem) || StringUtils.isBlank((CharSequence)businessUnitCode)) {
            return Lists.newArrayList();
        }
        List<AuditExecuteIndicatorVo> indicatorVoList = this.auditExecuteIndicatorRepository.findByActiveNumber(activeNumbers, dockingSystem, businessUnitCode);
        if (CollectionUtils.isEmpty(indicatorVoList)) {
            return Lists.newArrayList();
        }
        return indicatorVoList;
    }

    public Map<String, String> findByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Maps.newHashMap();
        }
        List keys = Lists.partition(onlyKeys, (int)500);
        List<AuditExecuteIndicatorOnlyKeyVo> list = this.auditExecuteIndicatorRepository.findByOnlyKeys(keys, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(AuditExecuteIndicatorOnlyKeyVo::getOnlyKey, UuidVo::getId, (oldValue, newValue) -> newValue));
    }

    public Map<String, BigDecimal> getSapAmountByDetailItemNos(List<String> itemNos, String nameType) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return Maps.newHashMap();
        }
        Validate.notBlank((CharSequence)nameType, (String)"\u672a\u6307\u5b9a\u67e5\u8be2\u540d\u79f0\u7c7b\u578b", (Object[])new Object[0]);
        Map dictMap = this.dictToolkitService.findMapByDictTypeCode("tpm_implementation_indicators");
        if (!dictMap.containsKey(nameType)) {
            return Maps.newHashMap();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditExecuteIndicatorRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditExecuteIndicator::getActiveNumber, itemNos)).eq(AuditExecuteIndicator::getIndicatorName, (Object)nameType)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (AuditExecuteIndicator indicator : list) {
            if (null == indicator.getIndicatorValue()) {
                indicator.setIndicatorValue(BigDecimal.ZERO);
            }
            if (map.containsKey(indicator.getActiveNumber())) {
                BigDecimal b = ((BigDecimal)map.get(indicator.getActiveNumber())).add(indicator.getIndicatorValue());
                map.put(indicator.getActiveNumber(), b);
                continue;
            }
            map.put(indicator.getActiveNumber(), indicator.getIndicatorValue());
        }
        log.error("sap\u53d1\u751f\u989d\u6570\u636e\uff1a{},\u7ec4\u88c5map\uff1a{}", (Object)list, map);
        return map;
    }

    public List<AuditExecuteIndicatorVo> getSapAmountAndQuantityByDetailItemNos(List<String> itemNos) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return Lists.newArrayList();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add("sapOccurrenceAmount");
        nameList.add("sapOccurrenceQuantity");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditExecuteIndicatorRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditExecuteIndicator::getActiveNumber, itemNos)).in(AuditExecuteIndicator::getIndicatorName, nameList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return new ArrayList<AuditExecuteIndicatorVo>(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<AuditExecuteIndicatorVo> findListForVariable(AuditExecuteIndicatorDto dto) {
        List<AuditExecuteIndicator> auditExecuteIndicatorList = this.auditExecuteIndicatorRepository.findListForVariable(dto);
        if (CollectionUtils.isEmpty(auditExecuteIndicatorList)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        Collection auditExecuteIndicatorVos = this.nebulaToolkitService.copyCollectionByBlankList(auditExecuteIndicatorList, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditExecuteIndicatorVos;
    }

    public List<AuditExecuteIndicatorVo> getPersonnelWage(AuditExecuteIndicatorDto dto) {
        List<AuditExecuteIndicator> list = this.auditExecuteIndicatorRepository.getPersonnelWage(dto);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<AuditExecuteIndicatorVo>();
        }
        Collection voList = this.nebulaToolkitService.copyCollectionByBlankList(list, AuditExecuteIndicator.class, AuditExecuteIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)voList;
    }

    public List<AuditExecuteIndicatorSdkVo> findSapDataByActiveNumbers(List<String> detailPlanItemCodes, List<String> indicatorNames) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes) || CollectionUtils.isEmpty(indicatorNames)) {
            return new ArrayList<AuditExecuteIndicatorSdkVo>();
        }
        List<AuditExecuteIndicator> list = this.auditExecuteIndicatorRepository.findSapDataByActiveNumbers(detailPlanItemCodes, indicatorNames);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<AuditExecuteIndicatorSdkVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, AuditExecuteIndicator.class, AuditExecuteIndicatorSdkVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditExecuteIndicatorVo> getMinusCompostQuantity(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setDetailPlanItemCodes(detailPlanItemCodes);
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setDockingSystem("cow_manager");
        dto.setIndicatorName(IndicatorNameEnum.DEDUCTION_QUANTITY.getCode());
        return this.auditExecuteIndicatorRepository.getMinusCompostQuantity(dto);
    }
}

