/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.alibaba.excel.util.Validate;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorStaffSalaryImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditExecuteIndicatorStaffSalaryImportProcess
implements ImportProcess<AuditExecuteIndicatorStaffSalaryImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteIndicatorStaffSalaryImportProcess.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private PromotersVoService promotersVoService;

    public Integer getBatchCount() {
        return 5000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, AuditExecuteIndicatorStaffSalaryImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, AuditExecuteIndicatorStaffSalaryImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            AuditExecuteIndicatorStaffSalaryImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getYearAndMonthStr()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getIndicatorName()), "\u6267\u884c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(vo.getIndicatorValue() != null, "\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getStoresCode()), "\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getStoresName()), "\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getPersonCode()), "\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getPersonName()), "\u4eba\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getEmployeeTypeName()), "\u5458\u5de5\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditExecuteIndicatorStaffSalaryImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap errMap = new HashMap();
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e00\u6b65");
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        List<AuditExecuteIndicatorDto> importList = this.validate(data, resultErrorMap);
        if (!resultErrorMap.isEmpty()) {
            return resultErrorMap;
        }
        this.auditExecuteIndicatorService.bulkImportSave(importList);
        log.error("\u6267\u884c\u6307\u6807\u5bfc\u5165\u7b2c\u4e8c\u6b65");
        return null;
    }

    private List<AuditExecuteIndicatorDto> validate(LinkedHashMap<Integer, AuditExecuteIndicatorStaffSalaryImportVo> data, Map<Integer, String> resultErrorMap) {
        ArrayList<AuditExecuteIndicatorStaffSalaryImportVo> importList = new ArrayList<AuditExecuteIndicatorStaffSalaryImportVo>(data.values());
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Map regionMap = this.dictToolkitService.findConvertMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)regionMap), (String)"\u672a\u67e5\u8be2\u5230\u96f6\u552e\u5546\u533a\u57df\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map employeeMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_employee_type");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)employeeMap), (String)"\u672a\u67e5\u8be2\u5230\u5458\u5de5\u7c7b\u578b\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map indicatorsMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_implementation_indicators");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)indicatorsMap), (String)"\u672a\u67e5\u8be2\u5230\u6267\u884c\u6307\u6807\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        int i = 1;
        for (AuditExecuteIndicatorStaffSalaryImportVo item : importList) {
            ++i;
            try {
                this.validateData(item, formatMap, unitMap, regionMap, employeeMap, indicatorsMap, i, resultErrorMap);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                String msg = "\u7b2c\u3010" + i + "\u3011\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage();
                resultErrorMap.put(i, msg);
                return new ArrayList<AuditExecuteIndicatorDto>();
            }
        }
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(importList, AuditExecuteIndicatorStaffSalaryImportVo.class, AuditExecuteIndicatorDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<AuditExecuteIndicatorDto>(dtoList);
    }

    private void validateData(AuditExecuteIndicatorStaffSalaryImportVo dto, Map<String, String> formatMap, Map<String, String> unitMap, Map<String, String> regionMap, Map<String, String> employeeMap, Map<String, String> indicatorsMap, Integer rowNum, Map<Integer, String> errMap) {
        String personnelId;
        String retailerName;
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)dto.getYearAndMonthStr()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
        String indicatorName = dto.getIndicatorName();
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)indicatorName), "\u6267\u884c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        this.validateIsTrue(null != dto.getIndicatorValue(), "\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        String employeeCode = indicatorsMap.get(indicatorName);
        this.validateIsTrue(StringUtils.isNotBlank((CharSequence)employeeCode), "\u6267\u884c\u6307\u6807\u540d\u79f0:" + indicatorName + "\u672a\u5339\u914d\u5230\u6267\u884c\u6307\u6807\u7f16\u7801!");
        dto.setIndicatorName(employeeCode);
        String personCode = dto.getPersonCode();
        PromotersVo promotersVo = this.promotersVoService.findByOutZwCode(personCode);
        if (ObjectUtils.isNotEmpty((Object)promotersVo)) {
            dto.setPersonName(promotersVo.getName());
        } else {
            this.validateIsTrue(false, "\u4eba\u5458\u7f16\u7801" + personCode + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String employeeTypeCode = employeeMap.get(dto.getEmployeeTypeName());
        if (StringUtils.isNotBlank((CharSequence)employeeTypeCode)) {
            dto.setEmployeeTypeCode(employeeTypeCode);
        } else {
            this.validateIsTrue(false, "\u5458\u5de5\u7c7b\u578b\u540d\u79f0:" + dto.getEmployeeTypeName() + "\u672a\u5339\u914d\u5230\u5458\u5de5\u7c7b\u578b\u7f16\u7801!");
        }
        ArrayList<String> terminalCodeList = new ArrayList<String>(1);
        terminalCodeList.add(dto.getStoresCode());
        List terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (CollectionUtils.isNotEmpty((Collection)terminalVos) && terminalVos.size() > 0) {
            dto.setStoresName(((TerminalVo)terminalVos.get(0)).getTerminalName());
        } else {
            this.validateIsTrue(false, "\u95e8\u5e97\u7f16\u7801" + dto.getStoresCode() + "\u672a\u5339\u914d\u5230\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String regionName = dto.getRegionName();
        if (StringUtils.isNotEmpty((CharSequence)regionName)) {
            String regionCode = regionMap.get(regionName);
            if (StringUtils.isNotBlank((CharSequence)regionCode)) {
                dto.setRegionCode(regionCode);
            } else {
                this.validateIsTrue(false, "\u6240\u5c5e\u5927\u533a\u540d\u79f0:" + regionName + "\u672a\u5339\u914d\u5230\u6240\u5c5e\u5927\u533a\u7f16\u7801!");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(retailerName = dto.getCustomerRetailerName()))) {
            List customerRetailerVoList = this.customerRetailerVoService.findByName(retailerName);
            if (CollectionUtils.isNotEmpty((Collection)customerRetailerVoList)) {
                if (customerRetailerVoList.size() == 1) {
                    dto.setCustomerRetailerCode((String)customerRetailerVoList.get(0));
                } else {
                    this.validateIsTrue(false, "\u6240\u5c5e\u96f6\u552e\u5546\u540d\u79f0:" + regionName + "\u5339\u914d\u5230\u6240\u5c5e\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u6b62\u4e00\u4e2a!");
                }
            } else {
                this.validateIsTrue(false, "\u6240\u5c5e\u96f6\u552e\u5546\u540d\u79f0:" + regionName + "\u672a\u5339\u914d\u5230\u6240\u5c5e\u96f6\u552e\u5546\u7f16\u7801!");
            }
        }
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            dto.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
        }
        if (unitMap.containsKey(dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(unitMap.get(dto.getBusinessUnitCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
        }
        try {
            dto.setYearAndMonth(DateUtil.date_yyyy_MM.parse(dto.getYearAndMonthStr()));
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getPersonnelId()) && StringUtils.isNotEmpty((CharSequence)(personnelId = dto.getPersonnelId().trim()))) {
            this.validateIsTrue(personnelId.length() == 18, "\u8eab\u4efd\u8bc1\u53f7\u5fc5\u987b\u7b49\u4e8e18\u4f4d");
        }
        dto.setDockingSystem("TPM");
        String errInfo = this.validateGetErrorInfo();
        if (errInfo != null) {
            errMap.put(rowNum, errInfo);
        }
    }

    public Class<AuditExecuteIndicatorStaffSalaryImportVo> findCrmExcelVoClass() {
        return AuditExecuteIndicatorStaffSalaryImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868";
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_EXECUTE_INDICATOR_STAFF_SALARY_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7ed3\u6848\u6838\u9500\u6267\u884c\u6307\u6807\u8868-\u4eba\u5458\u5de5\u8d44";
    }
}

