/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerQueryActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.service.CowManagerService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.CowManagerActivityExecutionService;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CowManagerActivityExecutionImpl
implements CowManagerActivityExecutionService {
    private static final Logger log = LoggerFactory.getLogger(CowManagerActivityExecutionImpl.class);
    @Autowired(required=false)
    private CowManagerService cowManagerService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryDisplayCostFromCowManager(String type, String upDateTime) {
        String key = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if ("displayCost".equals(type)) {
            key = key + "displayCost";
        }
        List<Object> list = new ArrayList<AuditExecuteIndicatorDto>();
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock("tpm_pull_cow_manager_data:lock:" + key, TimeUnit.HOURS, 12L);
            if (!lock) {
                throw new RuntimeException("\u6709\u4efb\u52a1\u6b63\u5728\u62c9\u53d6\u725b\u4eba\u7ba1\u5bb6\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
            }
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u624b\u52a8\u62c9\u53d6\u6d3b\u52a8,\u5f00\u59cb");
            CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();
            dto.setType(type);
            dto.setUpDataTime(upDateTime);
            List disExecutionList = this.cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty((Collection)disExecutionList)) {
                list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)disExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
            }
            this.saveOrUpdate(list, type);
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u624b\u52a8\u62c9\u53d6\u6d3b\u52a8,\u7ed3\u675f");
        }
        catch (Exception e) {
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u624b\u52a8\u62c9\u53d6\u6d3b\u52a8,\u4efb\u52a1\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("tpm_pull_cow_manager_data:lock:" + key);
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.clear();
            }
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u624b\u52a8\u62c9\u53d6\u6d3b\u52a8,\u4efb\u52a1\u5b8c\u6210\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DynamicTaskService(cornExpression="0 0 4 * * ?", taskDesc="\u6bcf\u59294\u70b9\u725b\u4eba\u7ba1\u5bb6\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f")
    public void autoQueryDisplayCostFromCowManager() {
        this.loginUserService.refreshAuthentication(null);
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.add(7, -1);
        String key = DateUtil.format((Date)curDate, (String)"yyyy-MM-dd") + "displayCost";
        String selectDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        List<Object> list = new ArrayList<AuditExecuteIndicatorDto>();
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock("tpm_pull_cow_manager_data:lock:" + key, TimeUnit.HOURS, 12L);
            if (!lock) {
                throw new RuntimeException("\u6709\u4efb\u52a1\u6b63\u5728\u62c9\u53d6\u725b\u4eba\u7ba1\u5bb6\u4e0a\u6708\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
            }
            CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u62c9\u53d6\u9648\u5217\u6d3b\u52a8,\u5f00\u59cb");
            dto.setType("displayCost");
            dto.setUpDataTime(selectDate);
            List disExecutionList = this.cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty((Collection)disExecutionList)) {
                list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)disExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
            }
            this.saveOrUpdate(list, "displayCost");
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u62c9\u53d6\u9648\u5217\u6d3b\u52a8,\u7ed3\u675f");
        }
        catch (Exception e) {
            log.info("\u6bcf\u67089\u53f75\u70b9\u4ece\u725b\u4eba\u7ba1\u5bb6\u67e5\u8be2\u4e0a\u6708\u9648\u5217\u6d3b\u52a8\u548c\u4fc3\u9500\u6d3b\u52a8\u4fe1\u606f,\u4efb\u52a1\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("tpm_pull_cow_manager_data:lock:" + key);
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.clear();
            }
            log.info("\u6bcf\u67089\u53f75\u70b9\u4ece\u725b\u4eba\u7ba1\u7406\u67e5\u8be2\u4e0a\u6708\u9648\u5217\u6d3b\u52a8\u548c\u4fc3\u9500\u6d3b\u52a8\u4fe1\u606f,\u4efb\u52a1\u5b8c\u6210\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DynamicTaskService(cornExpression="0 0 1 13 * ?", taskDesc="\u6bcf\u670813\u53f71\u70b9\u62c9\u53d6\u725b\u4eba\u7ba1\u5bb6\u67e5\u8be2\u4fc3\u9500\u884c\u9500\u6d3b\u52a8\u4fe1\u606f")
    public void autoQueryMarketingCostFromCowManager() {
        this.loginUserService.refreshAuthentication(null);
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.add(2, -1);
        String key = DateUtil.format((Date)curDate, (String)"yyyy-MM");
        List<Object> list = new ArrayList<AuditExecuteIndicatorDto>();
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock("tpm_pull_cow_manager_data:lock:" + key, TimeUnit.HOURS, 12L);
            if (!lock) {
                throw new RuntimeException("\u6709\u4efb\u52a1\u6b63\u5728\u62c9\u53d6\u725b\u4eba\u7ba1\u5bb6\u4e0a\u6708\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...");
            }
            CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u62c9\u53d6\u884c\u9500\u6d3b\u52a8,\u5f00\u59cb");
            dto.setType("marketingCost");
            List marExecutionList = this.cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty((Collection)marExecutionList)) {
                list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)marExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
            }
            this.saveOrUpdate(list, "marketingCost");
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u62c9\u53d6\u884c\u9500\u6d3b\u52a8,\u7ed3\u675f");
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u62c9\u53d6\u4fc3\u9500\u6d3b\u52a8,\u5f00\u59cb");
            dto.setType("promotionCost");
            List proExecutionList = this.cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty((Collection)proExecutionList)) {
                list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)proExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
            }
            this.saveOrUpdate(list, "promotionCost");
            log.info("\u6267\u884c\u6307\u6807-\u725b\u4eba\u7ba1\u5bb6,\u62c9\u53d6\u4fc3\u9500\u6d3b\u52a8,\u7ed3\u675f");
        }
        catch (Exception e) {
            log.info("\u6bcf\u670813\u53f71\u70b9\u4ece\u725b\u4eba\u7ba1\u5bb6\u67e5\u8be2\u4e0a\u6708\u9648\u5217\u6d3b\u52a8\u548c\u4fc3\u9500\u6d3b\u52a8\u4fe1\u606f,\u4efb\u52a1\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("tpm_pull_cow_manager_data:lock:" + key);
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.clear();
            }
            log.info("\u6bcf\u670813\u53f71\u70b9\u4ece\u725b\u4eba\u7ba1\u7406\u67e5\u8be2\u4e0a\u6708\u9648\u5217\u6d3b\u52a8\u548c\u4fc3\u9500\u6d3b\u52a8\u4fe1\u606f,\u4efb\u52a1\u5b8c\u6210\uff01");
        }
    }

    private void saveOrUpdate(List<AuditExecuteIndicatorDto> indicatorDtoList, String type) {
        int size;
        if (CollectionUtils.isEmpty(indicatorDtoList)) {
            return;
        }
        int partialLimit = QueryConstant.ONCE_SAVE_MAX;
        if (partialLimit < (size = indicatorDtoList.size())) {
            int start = 0;
            while (size > 0) {
                if (size < partialLimit) {
                    partialLimit = size;
                }
                List<AuditExecuteIndicatorDto> partList = indicatorDtoList.subList(start, partialLimit);
                size -= partialLimit;
                this.bulkSave(partList, type);
                partList.clear();
            }
        } else {
            this.bulkSave(indicatorDtoList, type);
        }
    }

    private void bulkSave(List<AuditExecuteIndicatorDto> partList, String type) {
        if (CollectionUtils.isEmpty(partList)) {
            return;
        }
        if (partList.size() > QueryConstant.ONCE_SAVE_MAX) {
            throw new IllegalArgumentException("\u725b\u4eba\u7ba1\u5bb6\u4fdd\u5b58\u65f6\uff0c\u5355\u6b21\u4fdd\u5b58\u66f4\u65b0\u603b\u6570\u4e0d\u80fd\u8d85\u8fc7:" + QueryConstant.ONCE_SAVE_MAX);
        }
        List itemCodes = partList.stream().map(AuditExecuteIndicatorDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        ArrayList list = new ArrayList();
        List indicatorVos = this.auditExecuteIndicatorService.findByActiveNumber(itemCodes, "cow_manager", BusinessUnitEnum.VERTICAL.getCode());
        ArrayList<String> detailItemCodes = new ArrayList<String>();
        ArrayList<String> diffTrackDetailCodes = new ArrayList<String>();
        for (String itemCode : itemCodes) {
            if (itemCode.startsWith("Z-")) {
                detailItemCodes.add(itemCode);
                continue;
            }
            if (!itemCode.startsWith("DHD")) continue;
            diffTrackDetailCodes.add(itemCode);
        }
        List detailItemVos = this.activityDetailPlanItemSdkService.findByItemCodes(detailItemCodes);
        List diffTrackDetailVos = this.auditFeeDiffTrackDetailVoService.findByDetailCodes(detailItemCodes);
        log.info("\u540c\u6b65\u725b\u4eba\u7ba1\u5bb6\u6570\u636e,partList:{}", (Object)partList.size());
        partList.forEach(exeDto -> {
            if (StringUtils.isNotBlank((CharSequence)exeDto.getActiveNumber())) {
                List<AuditExecuteIndicatorVo> items = indicatorVos.stream().filter(k -> k.getActiveNumber().equals(exeDto.getActiveNumber())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(items)) {
                    AuditFeeDiffTrackDetailVo trackDetailVo;
                    List<AuditExecuteIndicatorDto> updateDtoList;
                    if (!CollectionUtils.isEmpty((Collection)detailItemVos)) {
                        ActivityDetailPlanItemVo detailPlanItem = detailItemVos.stream().filter(v -> ((AuditExecuteIndicatorVo)items.get(0)).getActiveNumber().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                        updateDtoList = this.buildInfo((AuditExecuteIndicatorDto)exeDto, items, detailPlanItem, type);
                        log.info("\u540c\u6b65\u725b\u4eba\u7ba1\u5bb6\u6570\u636e,updateList:{}", (Object)updateDtoList.size());
                        if (!CollectionUtils.isEmpty(updateDtoList)) {
                            list.addAll(updateDtoList);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)diffTrackDetailVos) && !CollectionUtils.isEmpty(updateDtoList = this.buildInfo((AuditExecuteIndicatorDto)exeDto, items, trackDetailVo = (AuditFeeDiffTrackDetailVo)diffTrackDetailVos.stream().filter(v -> ((AuditExecuteIndicatorVo)items.get(0)).getActiveNumber().equals(v.getDetailCode())).findFirst().orElse(null), type))) {
                        list.addAll(updateDtoList);
                    }
                } else {
                    AuditFeeDiffTrackDetailVo trackDetailVo;
                    List<AuditExecuteIndicatorDto> createList;
                    if (!CollectionUtils.isEmpty((Collection)detailItemVos)) {
                        ActivityDetailPlanItemVo detailPlanItem = detailItemVos.stream().filter(v -> exeDto.getActiveNumber().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                        createList = this.buildInfo((AuditExecuteIndicatorDto)exeDto, items, detailPlanItem, type);
                        log.info("\u540c\u6b65\u725b\u4eba\u7ba1\u5bb6\u6570\u636e,createList:{}", (Object)createList.size());
                        if (!CollectionUtils.isEmpty(createList)) {
                            list.addAll(createList);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)diffTrackDetailVos) && !CollectionUtils.isEmpty(createList = this.buildInfo((AuditExecuteIndicatorDto)exeDto, items, trackDetailVo = (AuditFeeDiffTrackDetailVo)diffTrackDetailVos.stream().filter(v -> exeDto.getActiveNumber().equals(v.getDetailCode())).findFirst().orElse(null), type))) {
                        list.addAll(createList);
                    }
                }
            }
        });
        this.auditExecuteIndicatorService.bulkImportSave(list);
    }

    private List<AuditExecuteIndicatorDto> buildInfo(AuditExecuteIndicatorDto exeDto, List<AuditExecuteIndicatorVo> items, ActivityDetailPlanItemVo detailPlanItem, String type) {
        if (ObjectUtils.isEmpty((Object)exeDto) || ObjectUtils.isEmpty((Object)detailPlanItem)) {
            return Lists.newArrayList();
        }
        ArrayList<AuditExecuteIndicatorDto> resultList = new ArrayList<AuditExecuteIndicatorDto>();
        if (!CollectionUtils.isEmpty(items)) {
            for (AuditExecuteIndicatorVo item : items) {
                item.setDockingSystem("cow_manager");
                item.setIsQualifiedCode(exeDto.getIsQualifiedCode());
                item.setIsQualified(exeDto.getIsQualified());
                item.setIsQualifiedReason(exeDto.getIsQualifiedReason());
                item.setActivityStatusCode(exeDto.getActivityStatusCode());
                item.setActivityStatus(exeDto.getActivityStatus());
                item.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
                item.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
                item.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
                item.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
                item.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
                item.setSalesRegionName(detailPlanItem.getSalesRegionName());
                item.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
                item.setSalesOrgName(detailPlanItem.getSalesOrgName());
                item.setChannelCode(detailPlanItem.getDistributionChannelCode());
                item.setChannelName(detailPlanItem.getDistributionChannelName());
                item.setCustomerCode(detailPlanItem.getCustomerCode());
                item.setCustomerName(detailPlanItem.getCustomerName());
                item.setStoresCode(detailPlanItem.getTerminalCode());
                item.setStoresName(detailPlanItem.getTerminalName());
                item.setPersonnelType(detailPlanItem.getPersonType());
                item.setPersonnelId(detailPlanItem.getPersonCode());
                item.setYearAndMonth(detailPlanItem.getFeeYearMonth());
                try {
                    item.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityBeginDate()));
                    item.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityEndDate()));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                item.setProductBrandCode(detailPlanItem.getProductBrandCode());
                item.setProductBrandName(detailPlanItem.getProductBrandName());
                item.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
                item.setProductCategoryName(detailPlanItem.getProductCategoryName());
                item.setProductItemCode(detailPlanItem.getProductItemCode());
                item.setProductItemName(detailPlanItem.getProductItemName());
                item.setProductCode(detailPlanItem.getProductCode());
                item.setProductName(detailPlanItem.getProductName());
                item.setActivityFormCode(detailPlanItem.getActivityFormCode());
                item.setActivityFormName(detailPlanItem.getActivityFormName());
                item.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
                item.setActivityTypeName(detailPlanItem.getActivityTypeName());
                item.setUpDataTime(exeDto.getUpDataTime());
                try {
                    if (IndicatorNameEnum.DEDUCTION_AMOUN.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank((CharSequence)exeDto.getDeductionExpenses())) {
                            item.setIndicatorValue(new BigDecimal(exeDto.getDeductionExpenses().trim()));
                        } else {
                            item.setInspectCosts(BigDecimal.ZERO);
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                        if (!StringUtils.isBlank((CharSequence)exeDto.getRegionInspectCost())) {
                            item.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                        } else {
                            item.setRegionInspectCosts(BigDecimal.ZERO);
                        }
                    }
                    if (IndicatorNameEnum.DEDUCTION_QUANTITY.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank((CharSequence)exeDto.getDeductionQuantity())) {
                            item.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                        } else {
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                    }
                    AuditExecuteIndicatorDto auditExecuteIndicatorDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
                    resultList.add(auditExecuteIndicatorDto);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6263\u51cf\u6d3b\u52a8\u91d1\u989d [" + exeDto.getInspectCost() + "] \u6216 \u6263\u51cf\u5927\u533a\u91d1\u989d [" + exeDto.getRegionInspectCost() + "] \u683c\u5f0f\u9519\u8bef");
                }
            }
        } else {
            exeDto.setDockingSystem("cow_manager");
            exeDto.setYearAndMonth(detailPlanItem.getFeeYearMonth());
            exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
            exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
            exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
            exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
            exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
            exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
            exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
            exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
            exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
            exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
            exeDto.setCustomerName(detailPlanItem.getCustomerName());
            exeDto.setStoresCode(detailPlanItem.getTerminalCode());
            exeDto.setStoresName(detailPlanItem.getTerminalName());
            exeDto.setPersonnelType(detailPlanItem.getPersonType());
            exeDto.setPersonnelId(detailPlanItem.getPersonCode());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityBeginDate()));
                exeDto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityEndDate()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
            exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
            exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
            exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
            exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
            exeDto.setProductItemName(detailPlanItem.getProductItemName());
            exeDto.setProductCode(detailPlanItem.getProductCode());
            exeDto.setProductName(detailPlanItem.getProductName());
            exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
            exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
            exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
            if ("displayCost".equals(type)) {
                AuditExecuteIndicatorDto auditExecuteIndicatorDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)exeDto, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
                auditExecuteIndicatorDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_QUANTITY.getCode());
                try {
                    if (!StringUtils.isBlank((CharSequence)auditExecuteIndicatorDto.getDeductionQuantity())) {
                        auditExecuteIndicatorDto.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6263\u51cf\u6570\u91cf [" + exeDto.getDeductionQuantity() + "]\u683c\u5f0f\u9519\u8bef");
                }
                resultList.add(auditExecuteIndicatorDto);
            }
            exeDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_AMOUN.getCode());
            try {
                if (!StringUtils.isBlank((CharSequence)exeDto.getDeductionExpenses())) {
                    exeDto.setIndicatorValue(new BigDecimal(exeDto.getDeductionExpenses().trim()));
                }
                if (!StringUtils.isBlank((CharSequence)exeDto.getRegionInspectCost())) {
                    exeDto.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                }
                resultList.add(exeDto);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6263\u51cf\u6d3b\u52a8\u91d1\u989d [" + exeDto.getInspectCost() + "] \u6216 \u6263\u51cf\u5927\u533a\u91d1\u989d [" + exeDto.getRegionInspectCost() + "] \u683c\u5f0f\u9519\u8bef");
            }
        }
        return resultList;
    }

    private List<AuditExecuteIndicatorDto> buildInfo(AuditExecuteIndicatorDto exeDto, List<AuditExecuteIndicatorVo> items, AuditFeeDiffTrackDetailVo detailPlanItem, String type) {
        if (ObjectUtils.isEmpty((Object)exeDto) || ObjectUtils.isEmpty((Object)detailPlanItem)) {
            return null;
        }
        ArrayList<AuditExecuteIndicatorDto> resultList = new ArrayList<AuditExecuteIndicatorDto>();
        if (CollectionUtils.isEmpty(items)) {
            for (AuditExecuteIndicatorVo item : items) {
                item.setDockingSystem("cow_manager");
                item.setIsQualifiedCode(exeDto.getIsQualifiedCode());
                item.setIsQualified(exeDto.getIsQualified());
                item.setIsQualifiedReason(exeDto.getIsQualifiedReason());
                item.setActivityStatusCode(exeDto.getActivityStatusCode());
                item.setActivityStatus(exeDto.getActivityStatus());
                item.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
                item.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
                item.setSalesInstitutionErpCode(detailPlanItem.getSalesInstitutionErpCode());
                item.setChannelCode(detailPlanItem.getDistributionChannelCode());
                item.setCustomerCode(detailPlanItem.getCustomerCode());
                item.setCustomerName(detailPlanItem.getCustomerName());
                item.setStoresCode(detailPlanItem.getTerminalCode());
                item.setStoresName(detailPlanItem.getTerminalName());
                item.setPersonnelId(detailPlanItem.getPersonIdCard());
                item.setYearAndMonth(detailPlanItem.getFeeYearMonth());
                try {
                    item.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityBeginDate()));
                    item.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityEndDate()));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                item.setProductBrandCode(detailPlanItem.getProductBrandCode());
                item.setProductBrandName(detailPlanItem.getProductBrandName());
                item.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
                item.setProductCategoryName(detailPlanItem.getProductCategoryName());
                item.setProductItemCode(detailPlanItem.getProductItemCode());
                item.setProductItemName(detailPlanItem.getProductItemName());
                item.setProductCode(detailPlanItem.getProductCode());
                item.setProductName(detailPlanItem.getProductName());
                item.setActivityFormCode(detailPlanItem.getActivityFormCode());
                item.setActivityFormName(detailPlanItem.getActivityFormName());
                item.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
                item.setActivityTypeName(detailPlanItem.getActivityTypeName());
                try {
                    if (IndicatorNameEnum.DEDUCTION_AMOUN.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank((CharSequence)exeDto.getInspectCost())) {
                            item.setInspectCosts(new BigDecimal(exeDto.getInspectCost().trim()));
                            item.setIndicatorValue(item.getInspectCosts());
                        } else {
                            item.setInspectCosts(BigDecimal.ZERO);
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                        if (!StringUtils.isBlank((CharSequence)exeDto.getRegionInspectCost())) {
                            item.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                        } else {
                            item.setRegionInspectCosts(BigDecimal.ZERO);
                        }
                    }
                    if (IndicatorNameEnum.DEDUCTION_QUANTITY.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank((CharSequence)exeDto.getDeductionQuantity())) {
                            item.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                        } else {
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                    }
                    AuditExecuteIndicatorDto auditExecuteIndicatorDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
                    resultList.add(auditExecuteIndicatorDto);
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6263\u51cf\u6d3b\u52a8\u91d1\u989d [" + exeDto.getInspectCost() + "] \u6216 \u6263\u51cf\u5927\u533a\u91d1\u989d [" + exeDto.getRegionInspectCost() + "] \u6216 \u6263\u51cf\u6570\u91cf [" + exeDto.getDeductionQuantity() + "]\u683c\u5f0f\u9519\u8bef");
                }
            }
        } else {
            exeDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_AMOUN.getCode());
            exeDto.setDockingSystem("cow_manager");
            exeDto.setYearAndMonth(detailPlanItem.getFeeYearMonth());
            exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
            exeDto.setSalesInstitutionErpCode(detailPlanItem.getSalesInstitutionErpCode());
            exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
            exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
            exeDto.setCustomerName(detailPlanItem.getCustomerName());
            exeDto.setStoresCode(detailPlanItem.getTerminalCode());
            exeDto.setStoresName(detailPlanItem.getTerminalName());
            exeDto.setPersonnelId(detailPlanItem.getPersonIdCard());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityBeginDate()));
                exeDto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityEndDate()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
            exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
            exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
            exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
            exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
            exeDto.setProductItemName(detailPlanItem.getProductItemName());
            exeDto.setProductCode(detailPlanItem.getProductCode());
            exeDto.setProductName(detailPlanItem.getProductName());
            exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
            exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
            exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
            if ("displayCost".equals(type)) {
                AuditExecuteIndicatorDto auditExecuteIndicatorDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)exeDto, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class, new String[0]);
                auditExecuteIndicatorDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_QUANTITY.getCode());
                try {
                    if (!StringUtils.isBlank((CharSequence)auditExecuteIndicatorDto.getDeductionQuantity())) {
                        exeDto.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6263\u51cf\u6570\u91cf [" + exeDto.getDeductionQuantity() + "]\u683c\u5f0f\u9519\u8bef");
                }
                resultList.add(auditExecuteIndicatorDto);
            }
            exeDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_AMOUN.getCode());
            try {
                if (!StringUtils.isBlank((CharSequence)exeDto.getInspectCost())) {
                    exeDto.setInspectCosts(new BigDecimal(exeDto.getInspectCost().trim()));
                    exeDto.setIndicatorValue(exeDto.getInspectCosts());
                }
                if (!StringUtils.isBlank((CharSequence)exeDto.getRegionInspectCost())) {
                    exeDto.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u6263\u51cf\u6d3b\u52a8\u91d1\u989d [" + exeDto.getInspectCost() + "] \u6216 \u6263\u51cf\u5927\u533a\u91d1\u989d [" + exeDto.getRegionInspectCost() + "] \u683c\u5f0f\u9519\u8bef");
            }
            resultList.add(exeDto);
        }
        return resultList;
    }
}

