/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.third.system.cow.personnel.center.sdk.dto.ShoppingGuideSalaryDto;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.repository.AuditExecuteIndicatorRepository;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.CowPersonnelExecutionService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CowPersonnelExecutionServiceImpl
implements CowPersonnelExecutionService {
    private static final Logger log = LoggerFactory.getLogger(CowPersonnelExecutionServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditExecuteIndicatorRepository auditExecuteIndicatorRepository;

    @Transactional(rollbackFor={Exception.class})
    public void shoppingGuideSalary(List<ShoppingGuideSalaryDto> dtoList) {
        ArrayList<AuditExecuteIndicatorDto> auditExecuteIndicatorDtoList = new ArrayList<AuditExecuteIndicatorDto>();
        for (ShoppingGuideSalaryDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getPeopleCode(), (String)"\u4eba\u5458\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getSalaryYearAndMonth(), (String)"\u5de5\u8d44\u5e74\u6708\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
            indicatorDto.setBusinessFormatCode("11");
            indicatorDto.setBusinessUnitCode("DY00000010");
            indicatorDto.setDockingSystem("cow_personnel");
            indicatorDto.setIndicatorName("personnelSalary");
            indicatorDto.setPersonCode(dto.getPeopleCode());
            indicatorDto.setPersonName(dto.getPeopleName());
            indicatorDto.setPersonIdCard(dto.getIdNumber());
            indicatorDto.setEmployeeTypeCode(dto.getStaffTypeCode());
            indicatorDto.setEmployeeTypeName(dto.getStaffTypeName());
            indicatorDto.setStoresCode(dto.getManageStoreCode());
            indicatorDto.setStoresName(dto.getManageStoreName());
            indicatorDto.setRegionCode(dto.getRegionCode());
            indicatorDto.setRegionName(dto.getRegionName());
            indicatorDto.setCustomerRetailerCode(dto.getShopkeeperCode());
            indicatorDto.setCustomerRetailerName(dto.getShopkeeperName());
            indicatorDto.setYearAndMonthStr(dto.getSalaryYearAndMonth() + "-01");
            indicatorDto.setYearAndMonth((Date)DateUtil.parse((CharSequence)indicatorDto.getYearAndMonthStr(), (String)"yyyy-MM-dd"));
            indicatorDto.setIndicatorValue(Optional.ofNullable(dto.getCompanyShouldPayTotalAmount()).orElse(BigDecimal.ZERO));
            indicatorDto.setTenantCode(TenantUtils.getTenantCode());
            indicatorDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            indicatorDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            AuditExecuteIndicator entity = this.auditExecuteIndicatorRepository.findByPeopleMonth(indicatorDto);
            if (entity != null) {
                indicatorDto.setId(entity.getId());
            }
            auditExecuteIndicatorDtoList.add(indicatorDto);
        }
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(auditExecuteIndicatorDtoList, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditExecuteIndicatorRepository.saveOrUpdateBatch(entities);
    }
}

