/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.local.executeIndicator.repository.AuditExecuteIndicatorRepository;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.ForeignAuditExecuteIndicatorApiAsyncService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForeignAuditExecuteIndicatorApiAsyncServiceImpl
implements ForeignAuditExecuteIndicatorApiAsyncService {
    private static final Logger log = LoggerFactory.getLogger(ForeignAuditExecuteIndicatorApiAsyncServiceImpl.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private AuditExecuteIndicatorRepository auditExecuteIndicatorRepository;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public void createFromActivityDetailPlan(List<AuditExecuteIndicatorDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new RuntimeException("\u65e0\u6570\u636e\u4e0a\u4f20");
        }
        list.forEach(item -> {
            Validate.notBlank((CharSequence)item.getActiveNumber(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getDockingSystem(), (String)"\u5bf9\u63a5\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getVariableCode(), (String)"\u6267\u884c\u6307\u6807\u53d8\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getIndicatorName(), (String)"\u6267\u884c\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)item.getIndicatorValue(), (String)"\u6267\u884c\u6307\u6807\u503c\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        });
        List itemCodeList = list.stream().map(AuditExecuteIndicatorDto::getActiveNumber).collect(Collectors.toList());
        List itemVoList = this.activityDetailPlanItemSdkService.findByItemCodes(itemCodeList);
        Map planItemVoMap = itemVoList.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
        for (AuditExecuteIndicatorDto auditExecuteIndicatorDto : list) {
            this.filledOtherValues(auditExecuteIndicatorDto, (ActivityDetailPlanItemVo)planItemVoMap.get(auditExecuteIndicatorDto.getActiveNumber()));
        }
        Map<String, List<AuditExecuteIndicatorDto>> groupMap = list.stream().collect(Collectors.groupingBy(item -> item.getBusinessUnitCode() + item.getVariableCode()));
        for (Map.Entry<String, List<AuditExecuteIndicatorDto>> entry : groupMap.entrySet()) {
            this.saveOrUpdateAuditExecuteIndicator(entry.getValue());
        }
    }

    private void saveOrUpdateAuditExecuteIndicator(List<AuditExecuteIndicatorDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        AuditExecuteIndicatorDto firstDto = list.get(0);
        List verticalItemCodes = list.stream().map(AuditExecuteIndicatorDto::getActiveNumber).collect(Collectors.toList());
        List indicatorVos = this.auditExecuteIndicatorService.findByActiveNumber(verticalItemCodes, firstDto.getVariableCode(), firstDto.getBusinessUnitCode());
        Map existsMap = indicatorVos.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, Function.identity(), (o, n) -> n));
        Date curDate = new Date();
        for (AuditExecuteIndicatorVo indicatorVo : indicatorVos) {
            indicatorVo.setYearAndMonth(curDate);
            if (!existsMap.containsKey(indicatorVo.getActiveNumber())) continue;
            indicatorVo.setId(((AuditExecuteIndicatorVo)existsMap.get(indicatorVo.getActiveNumber())).getId());
        }
        this.auditExecuteIndicatorService.bulkImportSave(list);
    }

    private void filledOtherValues(AuditExecuteIndicatorDto exeDto, ActivityDetailPlanItemVo detailPlanItem) {
        if (ObjectUtils.isNotEmpty((Object)detailPlanItem) && !ObjectUtils.isEmpty((Object)exeDto)) {
            exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
            exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
            exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
            exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
            exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
            exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
            exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
            exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
            exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
            exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
            exeDto.setCustomerName(detailPlanItem.getCustomerName());
            exeDto.setStoresCode(detailPlanItem.getTerminalCode());
            exeDto.setStoresName(detailPlanItem.getTerminalName());
            exeDto.setPersonnelType(detailPlanItem.getPersonType());
            exeDto.setPersonnelId(detailPlanItem.getPersonCode());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityBeginDate()));
                exeDto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityEndDate()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
            exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
            exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
            exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
            exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
            exeDto.setProductItemName(detailPlanItem.getProductItemName());
            exeDto.setProductCode(detailPlanItem.getProductCode());
            exeDto.setProductName(detailPlanItem.getProductName());
            exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
            exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
            exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
        }
    }
}

