/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.QueryActivitySapCallbackService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class QueryActivitySapCallbackServiceImpl
implements QueryActivitySapCallbackService {
    private static final Logger log = LoggerFactory.getLogger(QueryActivitySapCallbackServiceImpl.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public void queryBranchCallback(PromotionActivityCallbackDto dto) {
        ArrayList<String> lockKey = new ArrayList<String>();
        try {
            if (ObjectUtils.isEmpty((Object)dto)) {
                return;
            }
            List item1 = dto.getITEM1();
            if (CollectionUtils.isEmpty((Collection)item1)) {
                return;
            }
            Iterator it = item1.iterator();
            while (it.hasNext()) {
                PromotionActivityCallbackDataDto next = (PromotionActivityCallbackDataDto)it.next();
                if (!StringUtils.isNotBlank((CharSequence)next.getZFHDITEM())) continue;
                boolean locked = this.redisLockService.tryLock("tpm_execute_indicator_sap:lock:" + next.getZFHDITEM(), TimeUnit.HOURS, 1L);
                if (locked) {
                    lockKey.add(next.getZFHDITEM());
                    continue;
                }
                it.remove();
            }
            this.generateSapExecuteIndicatorData(item1);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u6307\u6807\u7ba1\u7406,SAP\u6267\u884c\u7ed3\u679c\u4fdd\u5b58\u5931\u8d25,\u4fe1\u606f\u5934:{}", (Object)JSON.toJSONString((Object)dto.getMessageHeader()));
            e.printStackTrace();
            throw new RuntimeException("\u6570\u636e\u5904\u7406\u5931\u8d25");
        }
        finally {
            if (!CollectionUtils.isEmpty(lockKey)) {
                this.redisLockService.batchUnLock("tpm_execute_indicator_sap:lock:", lockKey);
            }
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            mqMessageVo.setTopic("TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag("TPM_SUB_COM_ACTIVITY_DESIGN_UPDATE_CLOSE_AMOUNT_TAG");
            this.rocketMqProducer.sendMqMsg(mqMessageVo, 180L);
        }
    }

    private void generateSapExecuteIndicatorData(List<PromotionActivityCallbackDataDto> item1) {
        List indicatorVos;
        String businessUnitCode;
        if (CollectionUtils.isEmpty(item1)) {
            return;
        }
        List<PromotionActivityCallbackDataDto> verticalExeDtoList = item1.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getZFCXHD()) && k.getZFCXHD().startsWith("Z-")).collect(Collectors.toList());
        List<PromotionActivityCallbackDataDto> subComExeDtoList = item1.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getZFHDITEM()) && k.getZFHDITEM().startsWith("P-")).collect(Collectors.toList());
        List<String> verticalItemCodes = verticalExeDtoList.stream().map(PromotionActivityCallbackDataDto::getZFCXHD).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> subComItemCodes = subComExeDtoList.stream().map(PromotionActivityCallbackDataDto::getZFHDITEM).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(verticalItemCodes)) {
            businessUnitCode = BusinessUnitEnum.VERTICAL.getCode();
            indicatorVos = this.auditExecuteIndicatorService.findByActiveNumber(verticalItemCodes, "SAP", businessUnitCode);
            this.buildInfo(businessUnitCode, verticalExeDtoList, indicatorVos, verticalItemCodes);
        }
        if (!CollectionUtils.isEmpty(subComItemCodes)) {
            businessUnitCode = BusinessUnitEnum.SON_COMPANY.getCode();
            indicatorVos = this.auditExecuteIndicatorService.findByActiveNumber(subComItemCodes, "SAP", businessUnitCode);
            this.buildInfo(businessUnitCode, subComExeDtoList, indicatorVos, subComItemCodes);
        }
    }

    private void buildInfo(String businessUnitCode, List<PromotionActivityCallbackDataDto> exeDtoList, List<AuditExecuteIndicatorVo> indicatorVos, List<String> itemCodes) {
        if (CollectionUtils.isEmpty(exeDtoList) || CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        ArrayList list = new ArrayList();
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            List itemVoList = this.activityDetailPlanItemSdkService.findByItemCodes(itemCodes);
            exeDtoList.forEach(exeDto -> {
                List<AuditExecuteIndicatorVo> indicatorVoList = indicatorVos.stream().filter(k -> exeDto.getZFCXHD().equals(k.getActiveNumber())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(indicatorVoList)) {
                    indicatorVoList.forEach(indicator -> {
                        ActivityDetailPlanItemVo detailPlanItem = itemVoList.stream().filter(v -> exeDto.getZFCXHD().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                        try {
                            if (IndicatorNameEnum.SAP_QUANTITY.getCode().equals(indicator.getIndicatorName())) {
                                AuditExecuteIndicatorDto amountDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null, new String[0]);
                                this.filledOtherValues(amountDto, detailPlanItem, null);
                                amountDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank((CharSequence)exeDto.getZFXSSL().trim())) {
                                    amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                                }
                                list.add(amountDto);
                            }
                            if (IndicatorNameEnum.SAP_INCURRED.getCode().equals(indicator.getIndicatorName())) {
                                AuditExecuteIndicatorDto incurredDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null, new String[0]);
                                this.filledOtherValues(incurredDto, detailPlanItem, null);
                                incurredDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank((CharSequence)exeDto.getZFDDFY().trim())) {
                                    incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                                }
                                list.add(incurredDto);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("\u6d3b\u52a8\u53d1\u751f\u6570\u91cf [" + exeDto.getZFXSSL() + "] \u6216 \u6d3b\u52a8\u53d1\u751f\u91d1\u989d [" + exeDto.getZFDDFY() + "] \u683c\u5f0f\u9519\u8bef");
                        }
                    });
                } else {
                    ActivityDetailPlanItemVo detailPlanItem = itemVoList.stream().filter(v -> exeDto.getZFCXHD().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)detailPlanItem)) {
                        try {
                            AuditExecuteIndicatorDto amountDto = new AuditExecuteIndicatorDto();
                            amountDto.setYearAndMonth(calendar.getTime());
                            amountDto.setDockingSystem("SAP");
                            amountDto.setActiveNumber(exeDto.getZFCXHD());
                            if (StringUtils.isNotBlank((CharSequence)exeDto.getZFXSSL().trim())) {
                                amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                            }
                            amountDto.setIndicatorName(IndicatorNameEnum.SAP_QUANTITY.getCode());
                            AuditExecuteIndicatorDto incurredDto = new AuditExecuteIndicatorDto();
                            incurredDto.setYearAndMonth(calendar.getTime());
                            incurredDto.setDockingSystem("SAP");
                            incurredDto.setActiveNumber(exeDto.getZFCXHD());
                            if (StringUtils.isNotBlank((CharSequence)exeDto.getZFDDFY().trim())) {
                                incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                            }
                            incurredDto.setIndicatorName(IndicatorNameEnum.SAP_INCURRED.getCode());
                            this.filledOtherValues(amountDto, detailPlanItem, null);
                            this.filledOtherValues(incurredDto, detailPlanItem, null);
                            list.add(amountDto);
                            list.add(incurredDto);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("\u6d3b\u52a8\u53d1\u751f\u6570\u91cf [" + exeDto.getZFXSSL() + "] \u6216 \u6d3b\u52a8\u53d1\u751f\u91d1\u989d [" + exeDto.getZFDDFY() + "] \u683c\u5f0f\u9519\u8bef");
                        }
                    }
                }
            });
        }
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(businessUnitCode)) {
            List subComItemList = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(itemCodes);
            exeDtoList.forEach(exeDto -> {
                List<AuditExecuteIndicatorVo> indicatorVoList = indicatorVos.stream().filter(k -> exeDto.getZFHDITEM().equals(k.getActiveNumber())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(indicatorVoList)) {
                    indicatorVoList.forEach(indicator -> {
                        SubComActivityDetailPlanItemVo subComItem = subComItemList.stream().filter(v -> exeDto.getZFHDITEM().equals(v.getConstituentDetailPlanItemCode())).findFirst().orElse(null);
                        try {
                            if (IndicatorNameEnum.SAP_QUANTITY.getCode().equals(indicator.getIndicatorName())) {
                                AuditExecuteIndicatorDto amountDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null, new String[0]);
                                this.filledOtherValues(amountDto, null, subComItem);
                                amountDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank((CharSequence)exeDto.getZFXSSL().trim())) {
                                    amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                                }
                                list.add(amountDto);
                            }
                            if (IndicatorNameEnum.SAP_INCURRED.getCode().equals(indicator.getIndicatorName())) {
                                AuditExecuteIndicatorDto incurredDto = (AuditExecuteIndicatorDto)this.nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null, new String[0]);
                                this.filledOtherValues(incurredDto, null, subComItem);
                                incurredDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank((CharSequence)exeDto.getZFDDFY().trim())) {
                                    incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                                }
                                list.add(incurredDto);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("\u6d3b\u52a8\u53d1\u751f\u6570\u91cf [" + exeDto.getZFXSSL() + "] \u6216 \u6d3b\u52a8\u53d1\u751f\u91d1\u989d [" + exeDto.getZFDDFY() + "] \u683c\u5f0f\u9519\u8bef");
                        }
                    });
                } else {
                    SubComActivityDetailPlanItemVo subComItem = subComItemList.stream().filter(v -> exeDto.getZFHDITEM().equals(v.getConstituentDetailPlanItemCode())).findFirst().orElse(null);
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)subComItem)) {
                        try {
                            AuditExecuteIndicatorDto amountDto = new AuditExecuteIndicatorDto();
                            amountDto.setYearAndMonth(calendar.getTime());
                            amountDto.setDockingSystem("SAP");
                            amountDto.setActiveNumber(exeDto.getZFHDITEM());
                            if (StringUtils.isNotBlank((CharSequence)exeDto.getZFXSSL().trim())) {
                                amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                            }
                            amountDto.setIndicatorName(IndicatorNameEnum.SAP_QUANTITY.getCode());
                            AuditExecuteIndicatorDto incurredDto = new AuditExecuteIndicatorDto();
                            incurredDto.setYearAndMonth(calendar.getTime());
                            incurredDto.setDockingSystem("SAP");
                            incurredDto.setActiveNumber(exeDto.getZFHDITEM());
                            if (StringUtils.isNotBlank((CharSequence)exeDto.getZFDDFY().trim())) {
                                incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                            }
                            incurredDto.setIndicatorName(IndicatorNameEnum.SAP_INCURRED.getCode());
                            this.filledOtherValues(amountDto, null, subComItem);
                            this.filledOtherValues(incurredDto, null, subComItem);
                            list.add(amountDto);
                            list.add(incurredDto);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("\u6d3b\u52a8\u53d1\u751f\u6570\u91cf [" + exeDto.getZFXSSL() + "] \u6216 \u6d3b\u52a8\u53d1\u751f\u91d1\u989d [" + exeDto.getZFDDFY() + "] \u683c\u5f0f\u9519\u8bef");
                        }
                    }
                }
            });
        }
        this.auditExecuteIndicatorService.bulkImportSave(list);
    }

    private void filledOtherValues(AuditExecuteIndicatorDto exeDto, ActivityDetailPlanItemVo detailPlanItem, SubComActivityDetailPlanItemVo subComItem) {
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)detailPlanItem) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)subComItem)) {
            return;
        }
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)detailPlanItem) && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)exeDto)) {
            exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
            exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
            exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
            exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
            exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
            exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
            exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
            exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
            exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
            exeDto.setCustomerName(detailPlanItem.getCustomerName());
            exeDto.setStoresCode(detailPlanItem.getTerminalCode());
            exeDto.setStoresName(detailPlanItem.getTerminalName());
            exeDto.setPersonnelType(detailPlanItem.getPersonType());
            exeDto.setPersonnelId(detailPlanItem.getPersonCode());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityBeginDate()));
                exeDto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)detailPlanItem.getActivityEndDate()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
            exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
            exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
            exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
            exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
            exeDto.setProductItemName(detailPlanItem.getProductItemName());
            exeDto.setProductCode(detailPlanItem.getProductCode());
            exeDto.setProductName(detailPlanItem.getProductName());
            exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
            exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
            exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
        }
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)subComItem) && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)exeDto)) {
            exeDto.setBusinessFormatCode(subComItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            exeDto.setSalesInstitutionCode(subComItem.getSalesInstitutionCode());
            exeDto.setSalesInstitutionName(subComItem.getSalesInstitutionName());
            exeDto.setSalesOrgCode(subComItem.getSalesOrgCode());
            exeDto.setSalesOrgName(subComItem.getSalesOrgName());
            exeDto.setChannelCode(subComItem.getDistributionChannelCode());
            exeDto.setChannelName(subComItem.getDistributionChannelName());
            if (!StringUtils.isBlank((CharSequence)subComItem.getCustomerCode()) && subComItem.getCustomerCode().length() <= 32) {
                exeDto.setCustomerCode(subComItem.getCustomerCode());
                exeDto.setCustomerName(subComItem.getCustomerName());
            }
            exeDto.setStoresCode(subComItem.getTerminalCode());
            exeDto.setStoresName(subComItem.getTerminalName());
            exeDto.setPersonnelType(subComItem.getPersonType());
            exeDto.setPersonnelId(subComItem.getPersonCode());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)subComItem.getActivityBeginTime()));
                exeDto.setActivityEndDate(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)subComItem.getActivityEndTime()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            exeDto.setProductBrandCode(subComItem.getProductBrandCode());
            exeDto.setProductBrandName(subComItem.getProductBrandName());
            exeDto.setProductCategoryCode(subComItem.getProductCategoryCode());
            exeDto.setProductCategoryName(subComItem.getProductCategoryName());
            exeDto.setProductItemCode(subComItem.getProductItemCode());
            exeDto.setProductItemName(subComItem.getProductItemName());
            exeDto.setProductCode(subComItem.getProductCode());
            exeDto.setProductName(subComItem.getProductName());
            exeDto.setActivityFormCode(subComItem.getActivityFormCode());
            exeDto.setActivityFormName(subComItem.getActivityFormName());
            exeDto.setActivityTypeCode(subComItem.getActivityType());
            exeDto.setActivityTypeName(subComItem.getActivityTypeName());
        }
    }

    public void queryHeadCallback(PromotionActivityCallbackDto dto) {
    }
}

