/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.QueryPromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.SapActivityExecution;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="SapActivityExecution")
public class SapActivityExecutionImpl
implements SapActivityExecution {
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ActivityPushSapApiService activityPushSapApiService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression="0 0 1,7,13,19 * * ?", taskDesc="\u4ecesap\u67e5\u8be2\u62c9\u53d6\u6d3b\u52a8\u6267\u884c\u7ed3\u679c")
    public void queryAllExecutionSapBranch() {
        this.loginUserService.refreshAuthentication(null);
        ArrayList<QueryPromotionActivityBranchDto> dtoList = new ArrayList<QueryPromotionActivityBranchDto>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        String lastDate = sif.format(calendar.getTime());
        QueryPromotionActivityBranchDto dtoVertical = new QueryPromotionActivityBranchDto();
        QueryPromotionActivityBranchDto.Item2 item2Vertical = new QueryPromotionActivityBranchDto.Item2();
        item2Vertical.setSIGN("I");
        item2Vertical.setOPTION("CP");
        item2Vertical.setLOW("Z*");
        dtoVertical.setITEM2(new ArrayList());
        dtoVertical.getITEM2().add(item2Vertical);
        QueryPromotionActivityBranchDto.Item4 item4Vertical = new QueryPromotionActivityBranchDto.Item4();
        item4Vertical.setSIGN("I");
        item4Vertical.setOPTION("EQ");
        item4Vertical.setLOW(lastDate);
        dtoVertical.setITEM4(new ArrayList());
        dtoVertical.getITEM4().add(item4Vertical);
        dtoList.add(dtoVertical);
        QueryPromotionActivityBranchDto dtoMolecule = new QueryPromotionActivityBranchDto();
        QueryPromotionActivityBranchDto.Item2 item2Molecule = new QueryPromotionActivityBranchDto.Item2();
        item2Molecule.setSIGN("I");
        item2Molecule.setOPTION("CP");
        item2Molecule.setLOW("P*");
        dtoMolecule.setITEM2(new ArrayList());
        dtoMolecule.getITEM2().add(item2Molecule);
        QueryPromotionActivityBranchDto.Item4 item4Molecule = new QueryPromotionActivityBranchDto.Item4();
        item4Molecule.setSIGN("I");
        item4Molecule.setOPTION("EQ");
        item4Molecule.setLOW(lastDate);
        dtoMolecule.setITEM4(new ArrayList());
        dtoMolecule.getITEM4().add(item4Molecule);
        dtoList.add(dtoMolecule);
        dtoList.forEach(dto -> this.activityPushSapApiService.pushQueryPromotionActivityBranch(dto));
    }

    public void queryExecutionSapBranch(String orgCode, String itemCode, String activityDate) {
        Validate.notBlank((CharSequence)itemCode, (String)"\u4fc3\u9500\u6d3b\u52a8\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String sapOrgCode = "";
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(orgCode);
            Map orgSapMap = this.salesOrgVoService.findSapCodesBySalesOrgCodes(list);
            Validate.notEmpty((Map)orgSapMap, (String)"\u672a\u67e5\u8be2\u5230\u9500\u552e\u7ec4\u7ec7\u5bf9\u5e94\u7684SAP\u7f16\u7801", (Object[])new Object[0]);
            sapOrgCode = (String)orgSapMap.get(orgCode);
            Validate.notBlank((CharSequence)sapOrgCode, (String)"\u672a\u67e5\u8be2\u5230\u9500\u552e\u7ec4\u7ec7\u5bf9\u5e94\u7684SAP\u7f16\u7801", (Object[])new Object[0]);
        }
        this.queryActivityExecutionFromSapBranch(sapOrgCode, itemCode, activityDate);
    }

    private void queryActivityExecutionFromSapBranch(String orgCode, String activityNo, String activityDate) {
        if (StringUtils.isBlank((CharSequence)activityNo)) {
            return;
        }
        QueryPromotionActivityBranchDto dto = new QueryPromotionActivityBranchDto();
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            QueryPromotionActivityBranchDto.Item1 item1 = new QueryPromotionActivityBranchDto.Item1();
            item1.setSIGN("I");
            item1.setOPTION("EQ");
            item1.setLOW(orgCode);
            dto.setITEM1(new ArrayList());
            dto.getITEM1().add(item1);
        }
        QueryPromotionActivityBranchDto.Item2 item2 = new QueryPromotionActivityBranchDto.Item2();
        item2.setSIGN("I");
        item2.setOPTION("EQ");
        item2.setLOW(activityNo);
        dto.setITEM2(new ArrayList());
        dto.getITEM2().add(item2);
        if (StringUtils.isNotBlank((CharSequence)activityDate)) {
            QueryPromotionActivityBranchDto.Item4 item4 = new QueryPromotionActivityBranchDto.Item4();
            item4.setSIGN("I");
            item4.setOPTION("EQ");
            item4.setLOW(activityDate);
            dto.setITEM4(new ArrayList());
            dto.getITEM4().add(item4);
        }
        this.activityPushSapApiService.pushQueryPromotionActivityBranch(dto);
    }
}

