/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityApplicationAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(ActivityApplicationAmountRegister.class);
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    public String getVariableCode() {
        return "activityApplicationAmount";
    }

    public String getVariableName() {
        return "\u6d3b\u52a8\u7533\u8bf7\u91d1\u989d\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull((Object)detailPlanItemCode, (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        if (detailPlanItemCode.startsWith("DHD")) {
            List vos = this.auditFeeDiffTrackDetailVoService.findByDetailCodes((List)Lists.newArrayList((Object[])new String[]{detailPlanItemCode}));
            if (!CollectionUtils.isEmpty((Collection)vos)) {
                resultMap.put(this.getVariableCode(), ((AuditFeeDiffTrackDetailVo)vos.get(0)).getFeeAmount());
            }
        } else {
            List vos = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes((Set)Sets.newHashSet((Object[])new String[]{detailPlanItemCode}), null);
            if (!CollectionUtils.isEmpty((Collection)vos)) {
                resultMap.put(this.getVariableCode(), ((ActivityDetailPlanItemVo)vos.get(0)).getFeeAmount());
            }
        }
        if (!resultMap.containsKey(this.getVariableCode())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        }
        return resultMap;
    }
}

