/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.SubComAuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubCompanyExecuteIndicatorUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DisplayReachStandardRateRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(DisplayReachStandardRateRegister.class);
    @Autowired(required=false)
    private SubCompanyExecuteIndicatorUtil subCompanyExecuteIndicatorUtil;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "displayReachStandardRate";
    }

    public String getVariableName() {
        return "\u9648\u5217\u8fbe\u6807\u7387\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), BigDecimal.ONE);
        AuditExecuteIndicatorDto dto = AuditExecuteIndicatorParamBuilder.buildMainParam(calculateDto, this.getVariableCode());
        List resultList = this.auditExecuteIndicatorService.findListForVariable(dto);
        BigDecimal indicatorValue = null;
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            indicatorValue = ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue();
        }
        if (Objects.nonNull(indicatorValue)) {
            resultMap.put(this.getVariableCode(), indicatorValue);
            return resultMap;
        }
        List<AuditExecuteIndicatorDto> paramList = SubComAuditExecuteIndicatorParamBuilder.buildOtherParamList(calculateDto, this.getVariableCode());
        AuditExecuteIndicatorDto customerDto = paramList.get(0);
        AuditExecuteIndicatorDto terminalDto = paramList.get(1);
        if (Objects.nonNull(customerDto)) {
            resultList = this.auditExecuteIndicatorService.findListForVariable(customerDto);
        }
        if (Objects.nonNull(terminalDto) && CollectionUtils.isEmpty((Collection)resultList)) {
            resultList = this.auditExecuteIndicatorService.findListForVariable(terminalDto);
        }
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            indicatorValue = ((AuditExecuteIndicatorVo)resultList.get(0)).getIndicatorValue();
        }
        if (Objects.nonNull(indicatorValue)) {
            resultMap.put(this.getVariableCode(), indicatorValue);
            return resultMap;
        }
        return resultMap;
    }
}

