/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementSumDto;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.kms.business.invoice.statement.sdk.vo.InvoiceStatementSumVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceStatementTaxPurchaseAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(InvoiceStatementTaxPurchaseAmountRegister.class);
    @Autowired(required=false)
    private InvoiceStatementVoService invoiceStatementVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getVariableCode() {
        return "invoiceStatementTaxPurchaseAmount";
    }

    public String getVariableName() {
        return "\u542b\u7a0e\u8fdb\u8d27\u989d(\u5782\u76f4)";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List codes;
        ProductLevelDto levelDto;
        log.error("\u8fdb\u5165\u6307\u6807\u8ba1\u7b97\u903b\u8f91\uff1a\u542b\u7a0e\u8fdb\u8d27\u989d(\u5782\u76f4)");
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        InvoiceStatementSumDto dto = new InvoiceStatementSumDto();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setGoodsCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductLevelCode(calculateDto.getItemCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodsCodes(codes);
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductCategoryCode(calculateDto.getCategoryCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodsCodes(codes);
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductBrandCode(calculateDto.getBrandCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodsCodes(codes);
        } else {
            throw new RuntimeException("\u4fc3\u9500\u6263\u6b3e\u91d1\u989d(\u5782\u76f4)\uff0c\u672a\u5f55\u5165\u4ea7\u54c1\u6216\u8005\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            dto.setDeliveryPartyCode(calculateDto.getStoresCode());
        } else {
            Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)calculateDto.getActivityOrgCode(), (String)"\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
            dto.setBusinessArea(calculateDto.getActivityOrgCode());
        }
        String end = DateUtil.date_yyyy_MM_dd.format(calculateDto.getEndTimeOrDate());
        String start = DateUtil.date_yyyy_MM_dd.format(calculateDto.getStartTimeOrDate());
        dto.setStartTime(start);
        dto.setEndTime(end);
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setExcludeGoodCodes(calculateDto.getExcludeProductCodeList());
        InvoiceStatementSumVo sumVo = this.invoiceStatementVoService.findAccAmountByConditions(dto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        if (ObjectUtils.isEmpty((Object)sumVo) || ObjectUtils.isEmpty((Object)sumVo.getStatementAccAmount())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), sumVo.getStatementAccAmount());
        return resultMap;
    }
}

