/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.local.register.vertical.common.VariableVerticalCommonBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PosPromotionDeductionRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PosPromotionDeductionRegister.class);
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private VariableVerticalCommonBuilder variableVerticalCommonBuilder;

    public String getVariableCode() {
        return "posPromotionDeduction";
    }

    public String getVariableName() {
        return "\u4fc3\u9500\u6263\u6b3e\u91d1\u989d(\u5782\u76f4)";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List codes;
        ProductLevelDto levelDto;
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        QueryConditionDto dto = new QueryConditionDto();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setGoodsCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductLevelCode(calculateDto.getItemCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductCategoryCode(calculateDto.getCategoryCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductBrandCode(calculateDto.getBrandCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodCodes(codes);
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            dto.setDeliveryPartyCode(calculateDto.getStoresCode());
        } else {
            Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)calculateDto.getActivityOrgCode(), (String)"\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
            dto.setBusinessArea(calculateDto.getActivityOrgCode());
        }
        List<String> channelNameList = this.variableVerticalCommonBuilder.getYongHuiChannelNameList(calculateDto);
        if (Objects.isNull(channelNameList)) {
            return resultMap;
        }
        String end = DateUtil.date_yyyy_MM_dd.format(calculateDto.getEndTimeOrDate());
        String start = DateUtil.date_yyyy_MM_dd.format(calculateDto.getStartTimeOrDate());
        dto.setEndTimeOrDate(end);
        dto.setStartTimeOrDate(start);
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setExcludeGoodCodes(calculateDto.getExcludeProductCodeList());
        dto.setChannelNameList(channelNameList);
        SalesDataVo salesDataVo = this.invoiceSalesDataVoService.findPromotionDeductionByCondition(dto);
        if (ObjectUtils.isEmpty((Object)salesDataVo) || ObjectUtils.isEmpty((Object)salesDataVo.getPromotionDeduction())) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesDataVo.getPromotionDeduction());
        return resultMap;
    }
}

