/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.local.register.vertical.common.VariableVerticalCommonBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PosSalesQuantityRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PosSalesQuantityRegister.class);
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private VariableVerticalCommonBuilder variableVerticalCommonBuilder;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    public String getVariableCode() {
        return "posSalesQuantity";
    }

    public String getVariableName() {
        return "pos\u9500\u552e\u91cf\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List vos;
        List codes;
        ProductLevelDto levelDto;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        Date endTimeOrDate = calculateDto.getEndTimeOrDate();
        Validate.notNull((Object)endTimeOrDate, (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Date startTimeOrDate = calculateDto.getStartTimeOrDate();
        Validate.notNull((Object)startTimeOrDate, (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        QueryConditionDto queryConditionDto = new QueryConditionDto();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            queryConditionDto.setGoodsCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductLevelCode(calculateDto.getItemCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            queryConditionDto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductCategoryCode(calculateDto.getCategoryCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            queryConditionDto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            levelDto = new ProductLevelDto();
            levelDto.setProductBrandCode(calculateDto.getBrandCode());
            codes = this.productVoService.findProductCodesByProductLevel(levelDto);
            queryConditionDto.setGoodCodes(codes);
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            queryConditionDto.setDeliveryPartyCode(calculateDto.getStoresCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getRetailBusinessmanName()) && StringUtils.isNotEmpty((CharSequence)calculateDto.getActivityOrgCode())) {
            queryConditionDto.setBusinessArea(calculateDto.getActivityOrgCode());
            queryConditionDto.setDirectName(calculateDto.getRetailBusinessmanName());
        } else {
            return resultMap;
        }
        String end = DateUtil.date_yyyy_MM_dd.format(endTimeOrDate);
        String start = DateUtil.date_yyyy_MM_dd.format(startTimeOrDate);
        queryConditionDto.setEndTimeOrDate(end);
        queryConditionDto.setStartTimeOrDate(start);
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull((Object)detailPlanItemCode, (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (detailPlanItemCode.startsWith("DHD")) {
            vos = this.auditFeeDiffTrackDetailVoService.findByDetailCodes((List)Lists.newArrayList((Object[])new String[]{detailPlanItemCode}));
            String retailerChannel = ((AuditFeeDiffTrackDetailVo)vos.get(0)).getRetailerChannel();
            if (StringUtils.isNotEmpty((CharSequence)retailerChannel) && !"\u5168\u6e20\u9053".equals(retailerChannel)) {
                queryConditionDto.setChannelNameList((List)Lists.newArrayList((Object[])new String[]{retailerChannel}));
            }
        } else {
            vos = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes((Set)Sets.newHashSet((Object[])new String[]{detailPlanItemCode}), null);
            String retailerChannel = ((ActivityDetailPlanItemVo)vos.get(0)).getRetailerChannel();
            if (StringUtils.isNotEmpty((CharSequence)retailerChannel) && !"\u5168\u6e20\u9053".equals(retailerChannel)) {
                queryConditionDto.setChannelNameList((List)Lists.newArrayList((Object[])new String[]{retailerChannel}));
            }
        }
        SalesDataVo salesDataVo = this.invoiceSalesDataVoService.findByCondition(queryConditionDto);
        if (ObjectUtils.isEmpty((Object)salesDataVo) || ObjectUtils.isEmpty((Object)salesDataVo.getCurUnitSalesQuantity())) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesDataVo.getCurUnitSalesQuantity());
        return resultMap;
    }
}

