/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.service.ActivityPutCostService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class PutCostManageService {
    private static final Logger log = LoggerFactory.getLogger(PutCostManageService.class);
    @Autowired(required=false)
    private ActivityPutCostService activityPutCostService;

    public void platformDeliveryFeesValidate(CalculateDto calculate) {
        log.info("\u5e73\u53f0\u6295\u653e\u8d39\u7528\u7ba1\u7406-\u6307\u6807\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)calculate));
        Validate.notNull((Object)calculate.getCustomerCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getStartTimeOrDate(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculate.getEndTimeOrDate(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculate.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public BigDecimal getPutCostAmount(CalculateDto calculate) {
        ActivityPutCostDto activityPutCost = new ActivityPutCostDto();
        activityPutCost.setCustomerCode(calculate.getCustomerErpCode());
        activityPutCost.setSalesInstitutionCode(calculate.getSalesOrganizationCode());
        activityPutCost.setBusinessFormatCode(calculate.getBusinessFormatCode());
        activityPutCost.setChannelCode(calculate.getChannel());
        activityPutCost.setActivityFormCode(calculate.getActivityFormCode());
        activityPutCost.setPutCostDateBegin(DateUtil.format((Date)calculate.getStartTimeOrDate(), (String)"yyyy-MM-dd") + " " + "00:00:00");
        activityPutCost.setPutCostDateEnd(DateUtil.format((Date)calculate.getEndTimeOrDate(), (String)"yyyy-MM-dd") + " " + "00:00:00");
        return this.activityPutCostService.getPutCostAmount(activityPutCost);
    }
}

