/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditExecuteIndicatorParamBuilder {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteIndicatorParamBuilder.class);

    public static AuditExecuteIndicatorDto buildMainParam(CalculateDto calculateDto, String variableCode) {
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setVariableCode(variableCode);
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getDetailPlanItemCode())) {
            dto.setActiveNumber(calculateDto.getDetailPlanItemCode());
        }
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)dto.getActiveNumber()) || AuditExecuteIndicatorParamBuilder.otherParamsVal(dto) ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01", (Object[])new Object[0]);
        return dto;
    }

    public static AuditExecuteIndicatorDto buildOtherParam(CalculateDto calculateDto, String variableCode) {
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setChannelCode(calculateDto.getChannel());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        dto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        dto.setStoresCode(calculateDto.getStoresCode());
        dto.setVariableCode(variableCode);
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)dto.getActiveNumber()) || AuditExecuteIndicatorParamBuilder.otherParamsVal(dto) ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01", (Object[])new Object[0]);
        return dto;
    }

    public static AuditExecuteIndicatorDto buildSubCompanyParam(CalculateDto calculateDto, String indicatorCode) {
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getDistributionChannel(), (String)"\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setCustomerCodes(Arrays.asList(calculateDto.getCustomerCode().split(",")));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            dto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
        }
        dto.setIndicatorCode(indicatorCode);
        return dto;
    }

    public static boolean otherParamsVal(AuditExecuteIndicatorDto calculateDto) {
        return StringUtils.isNotEmpty((CharSequence)calculateDto.getBusinessFormatCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getBusinessUnitCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getCustomerCode()) || Objects.nonNull(calculateDto.getYearAndMonth()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getYearStr()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesInstitutionCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesRegionCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getSalesOrgCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode()) || Objects.nonNull(calculateDto.getActivityBeginDate()) || Objects.nonNull(calculateDto.getActivityEndDate()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getCustomerRetailerCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getPersonIdCard()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getFirstChannelCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getSecondChannelCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getProductBrandCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCategoryCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getProductItemCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getHeadBudgetItemCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getMonthBudgetCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getSpecification()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getIsTemporary()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getIndicatorCode()) || CollectionUtils.isNotEmpty((Collection)calculateDto.getCustomerCodes()) || CollectionUtils.isNotEmpty((Collection)calculateDto.getStoresCodes()) || CollectionUtils.isNotEmpty((Collection)calculateDto.getProductCodeList()) || CollectionUtils.isNotEmpty((Collection)calculateDto.getProductItemCodeList()) || CollectionUtils.isNotEmpty((Collection)calculateDto.getProductCategoryCodeList()) || CollectionUtils.isNotEmpty((Collection)calculateDto.getProductBrandCodeList()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getActivityTypeCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getActivityFormCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getChannelCode());
    }
}

