/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubComAuditExecuteIndicatorParamBuilder {
    private static final Logger log = LoggerFactory.getLogger(SubComAuditExecuteIndicatorParamBuilder.class);

    public static List<AuditExecuteIndicatorDto> buildOtherParamList(CalculateDto calculateDto, String variableCode) {
        ArrayList<AuditExecuteIndicatorDto> list = new ArrayList<AuditExecuteIndicatorDto>();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCustomerCode())) {
            AuditExecuteIndicatorDto customerDto = SubComAuditExecuteIndicatorParamBuilder.buildOtherParam(calculateDto, variableCode);
            customerDto.setCustomerCode(calculateDto.getCustomerCode());
            list.add(customerDto);
        } else {
            list.add(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            AuditExecuteIndicatorDto terminalDto = SubComAuditExecuteIndicatorParamBuilder.buildOtherParam(calculateDto, variableCode);
            terminalDto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    private static AuditExecuteIndicatorDto buildOtherParam(CalculateDto calculateDto, String variableCode) {
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setChannelCode(calculateDto.getChannel());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        dto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        dto.setVariableCode(variableCode);
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)dto.getActiveNumber()) || AuditExecuteIndicatorParamBuilder.otherParamsVal(dto) ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff01", (Object[])new Object[0]);
        return dto;
    }

    public static List<AuditExecuteIndicatorDto> buildSubComParamList(CalculateDto calculateDto, String variableCode) {
        ArrayList<AuditExecuteIndicatorDto> list = new ArrayList<AuditExecuteIndicatorDto>();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCustomerCode())) {
            AuditExecuteIndicatorDto customerDto = SubComAuditExecuteIndicatorParamBuilder.buildSubComParam(calculateDto, variableCode);
            customerDto.setCustomerCode(calculateDto.getCustomerCode());
            list.add(customerDto);
        } else {
            list.add(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            AuditExecuteIndicatorDto terminalDto = SubComAuditExecuteIndicatorParamBuilder.buildSubComParam(calculateDto, variableCode);
            terminalDto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    private static AuditExecuteIndicatorDto buildSubComParam(CalculateDto calculateDto, String variableCode) {
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        dto.setIndicatorCode(variableCode);
        return dto;
    }
}

