/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditFeeVariableP0007Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVariableP0007Register.class);
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    public String getVariableCode() {
        return "AUDITFEEP0007";
    }

    public String getVariableName() {
        return "POS\uff08\u542b\u7a0e\uff09";
    }

    public Integer getSort() {
        return 7;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        Validate.notNull((Object)calculateDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getDeliveryPartyCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SalesDataDto selectDto = new SalesDataDto();
        selectDto.setGoodsCode(calculateDto.getProductCode());
        selectDto.setDeliveryPartyCode(calculateDto.getDeliveryPartyCode());
        selectDto.setStartTime(DateUtil.format((Date)calculateDto.getStartTimeOrDate(), (String)"yyyy-MM-dd"));
        selectDto.setEndTime(DateUtil.format((Date)calculateDto.getEndTimeOrDate(), (String)"yyyy-MM-dd"));
        BigDecimal variable = this.invoiceSalesDataVoService.findSummaryForVariable(selectDto);
        resultMap.put(this.getVariableCode(), Optional.ofNullable(variable).orElse(BigDecimal.ZERO));
        log.info("AUDITFEEP0007resultMap:{}", (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

