/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeVariableP0013Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVariableP0013Register.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    public String getVariableCode() {
        return "AUDITFEEP0013";
    }

    public String getVariableName() {
        return "\u7533\u8bf7\u91d1\u989d";
    }

    public Integer getSort() {
        return 13;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank((CharSequence)calculateDto.getCode()) || StringUtils.isBlank((CharSequence)calculateDto.getDataSource())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        }
        String dataSource = calculateDto.getDataSource();
        BigDecimal applyAmount = BigDecimal.ZERO;
        if (DataSourceEnum.ACTIVITY_DETAIL.getCode().equals(dataSource)) {
            List itemVos = this.activityDetailPlanItemSdkService.findDetailAndExtendByItemCodes((List)Lists.newArrayList((Object[])new String[]{calculateDto.getCode()}));
            if (!CollectionUtils.isEmpty((Collection)itemVos)) {
                applyAmount = ((ActivityDetailPlanItemVo)itemVos.get(0)).getFeeAmount();
            }
        } else if (DataSourceEnum.SON_ACTIVITY_DETAIL.getCode().equals(dataSource)) {
            // empty if block
        }
        resultMap.put(this.getVariableCode(), applyAmount);
        log.info("AUDITFEEP00013resultMap:{}", (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

