/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeVariableP0014Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVariableP0014Register.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    public String getVariableCode() {
        return "AUDITFEEP0014";
    }

    public String getVariableName() {
        return "\u5355\u4ef6\u7533\u8bf7\u8d39\u7528";
    }

    public Integer getSort() {
        return 14;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank((CharSequence)calculateDto.getCode()) || StringUtils.isBlank((CharSequence)calculateDto.getDataSource())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        }
        String dataSource = calculateDto.getDataSource();
        BigDecimal singleApplicationFee = BigDecimal.ZERO;
        if (DataSourceEnum.ACTIVITY_DETAIL.getCode().equals(dataSource)) {
            List itemVos = this.activityDetailPlanItemSdkService.findDetailAndExtendByItemCodes((List)Lists.newArrayList((Object[])new String[]{calculateDto.getCode()}));
            if (!CollectionUtils.isEmpty((Collection)itemVos)) {
                singleApplicationFee = ((ActivityDetailPlanItemVo)itemVos.get(0)).getSingleApplicationFee();
            }
        } else if (DataSourceEnum.SON_ACTIVITY_DETAIL.getCode().equals(dataSource)) {
            // empty if block
        }
        resultMap.put(this.getVariableCode(), singleApplicationFee);
        log.info("AUDITFEEP00014resultMap:{}", (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

