/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeVariableP0015Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVariableP0015Register.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "AUDITFEEP0015";
    }

    public String getVariableName() {
        return "\u9648\u5217\u6263\u51cf\u91d1\u989d";
    }

    public Integer getSort() {
        return 15;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank((CharSequence)calculateDto.getCode()) || StringUtils.isBlank((CharSequence)calculateDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)calculateDto.getBusinessUnitCode())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        BigDecimal displayDeductAmount = BigDecimal.ZERO;
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setActiveNumber(calculateDto.getCode());
        dto.setDockingSystem("cow_manager");
        dto.setIndicatorName("deductionAmount");
        List list = this.auditExecuteIndicatorService.findListForVariable(dto);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            displayDeductAmount = ((AuditExecuteIndicatorVo)list.get(0)).getIndicatorValue();
        }
        resultMap.put(this.getVariableCode(), displayDeductAmount);
        log.info("AUDITFEEP00015resultMap:{}", (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

