/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeVariableP0016Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVariableP0016Register.class);
    @Autowired(required=false)
    private AuditFeeCheckPosVoService auditFeeCheckPosVoService;

    public String getVariableCode() {
        return "AUDITFEEP0016";
    }

    public String getVariableName() {
        return "POS\u4fc3\u9500\u6263\u6b3e\uff08\u542b\u7a0e\uff09";
    }

    public Integer getSort() {
        return 7;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Page result;
        log.info("AUDITFEEP0016param:{}", (Object)JSONObject.toJSONString((Object)calculateDto));
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank((CharSequence)calculateDto.getCode()) || StringUtils.isBlank((CharSequence)calculateDto.getActivityDetailItemCode()) || StringUtils.isBlank((CharSequence)calculateDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)calculateDto.getBusinessUnitCode())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        BigDecimal displayDeductAmount = BigDecimal.ZERO;
        AuditFeeCheckPosDto dto = new AuditFeeCheckPosDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setActivityDetailItemCode(calculateDto.getActivityDetailItemCode());
        PageRequest page = PageRequest.of((int)1, (int)1000);
        do {
            result = this.auditFeeCheckPosVoService.findByConditions((Pageable)page, dto);
            log.info("AUDITFEEP0016detailItemCode:{},result:{}", (Object)calculateDto.getActivityDetailItemCode(), (Object)JSONObject.toJSONString((Object)result));
            if (result == null) break;
            if (CollectionUtils.isEmpty((Collection)result.getRecords())) continue;
            displayDeductAmount = displayDeductAmount.add(result.getRecords().stream().map(AuditFeeCheckPosVo::getPromotionDeduction).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        } while (result.hasNext());
        resultMap.put(this.getVariableCode(), displayDeductAmount);
        log.info("AUDITFEEP0016detailItemCode:{}, resultMap:{}", (Object)calculateDto.getActivityDetailItemCode(), (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

