/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditFeeVariableP0017Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVariableP0017Register.class);
    @Autowired(required=false)
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;

    public String getVariableCode() {
        return "AUDITFEEP0017";
    }

    public String getVariableName() {
        return "\u4fc3\u9500\u8d39\u7528\uff08\u542b\u7a0e\uff09";
    }

    public Integer getSort() {
        return 17;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        log.info("AUDITFEEP00017param:{}", (Object)JSONObject.toJSONString((Object)calculateDto));
        if (Objects.isNull(calculateDto) || StringUtils.isBlank((CharSequence)calculateDto.getCode()) || StringUtils.isBlank((CharSequence)calculateDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)calculateDto.getBusinessUnitCode()) || StringUtils.isBlank((CharSequence)calculateDto.getRetailBusinessmanCode()) || StringUtils.isBlank((CharSequence)calculateDto.getDeliveryPartyCode()) || StringUtils.isBlank((CharSequence)calculateDto.getProductCode()) || StringUtils.isBlank((CharSequence)calculateDto.getYearMonthLy())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        BigDecimal displayDeductAmount = BigDecimal.ZERO;
        InvoiceExpenseSheetDto sheetDto = new InvoiceExpenseSheetDto();
        sheetDto.setUrl("\u4fc3\u9500");
        sheetDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        sheetDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        sheetDto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
        sheetDto.setDeliveryPartyCode(calculateDto.getDeliveryPartyCode());
        sheetDto.setProductCode(calculateDto.getProductCode());
        sheetDto.setOrderYearMonth(calculateDto.getYearMonthLy());
        log.info("AUDITFEEP00017dto:{}", (Object)JSONObject.toJSONString((Object)sheetDto));
        BigDecimal bigDecimal = this.invoiceExpenseSheetVoService.promotionExpensesForFormula(sheetDto);
        log.info("AUDITFEEP00017apiResult:{}", (Object)JSONObject.toJSONString((Object)bigDecimal));
        displayDeductAmount = bigDecimal == null ? displayDeductAmount : bigDecimal;
        resultMap.put(this.getVariableCode(), displayDeductAmount);
        log.info("AUDITFEEP00017resultMap:{}", (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}

