/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActualSalesRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(ActualSalesRegister.class);
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    public String getVariableCode() {
        return "actualSales";
    }

    public String getVariableName() {
        return "\u6d3b\u52a8\u671f\u95f4\u53ca\u6d3b\u52a8\u4ea7\u54c1\u5b9e\u9500\u91cf\uff08\u4ef6\uff09\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)calculateDto.getCustomerCodeList(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MainOnedaySalesDataDto mainOnedaySalesData = new MainOnedaySalesDataDto();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            mainOnedaySalesData.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            mainOnedaySalesData.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            mainOnedaySalesData.setProductCategoryCode(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode()) && !StringUtils.equals((CharSequence)"130000", (CharSequence)calculateDto.getBrandCode())) {
            mainOnedaySalesData.setProductBrandCode(calculateDto.getBrandCode());
        }
        mainOnedaySalesData.setCustomerCodeList((List)Lists.newArrayList((Iterable)calculateDto.getCustomerCodeList()));
        mainOnedaySalesData.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        mainOnedaySalesData.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String startDate = format.format(calculateDto.getStartTimeOrDate());
        mainOnedaySalesData.setStartTimeOrDate(startDate);
        String endDate = format.format(calculateDto.getEndTimeOrDate());
        mainOnedaySalesData.setEndTimeOrDate(endDate);
        List resultList = this.mainOnedaySaleDataService.listMainOnedaySalesData(mainOnedaySalesData);
        HashMap resultMap = Maps.newHashMap();
        BigDecimal resultDecimal = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            resultMap.put(this.getVariableCode(), resultDecimal);
            return resultMap;
        }
        resultDecimal = resultList.stream().map(MainOnedaySalesDataVo::getMinusSaleQuantity).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, (xva$0, xva$1) -> BigDecimalUtils.sum(xva$0, xva$1));
        resultMap.put(this.getVariableCode(), resultDecimal);
        return resultMap;
    }
}

