/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CarCompensationSettlementAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(CarCompensationSettlementAmountRegister.class);
    @Autowired(required=false)
    private AuditCarSubsidyVoService auditCarSubsidyVoService;

    public String getVariableCode() {
        return "carCompensationSettlementAmount";
    }

    public String getVariableName() {
        return "\u8f66\u8865\u7ed3\u6848\u91d1\u989d\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String dealerCode = calculateDto.getDealerCode();
        Validate.notNull((Object)dealerCode, (String)"sap\u5e02\u573a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String yearMonthLy = calculateDto.getYearMonthLy();
        Validate.notNull((Object)yearMonthLy, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        try {
            DateUtil.date_yyyy_MM.parse(yearMonthLy);
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException("\u5e74\u6708\u7684\u683c\u5f0f\u5e94\u4e3a\u3010yyyy-MM\u3011!");
        }
        AuditCarSubsidyDto carSubsidyDto = new AuditCarSubsidyDto();
        carSubsidyDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        carSubsidyDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        carSubsidyDto.setStatisticsMonth(yearMonthLy);
        carSubsidyDto.setSalesRegionCode("20116000");
        carSubsidyDto.setDealerCode(dealerCode);
        AuditCarSubsidyVo auditCarSubsidyVo = this.auditCarSubsidyVoService.findValueByConditions(carSubsidyDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        if (ObjectUtils.isEmpty((Object)auditCarSubsidyVo) || ObjectUtils.isEmpty((Object)auditCarSubsidyVo.getMonthlyAmount())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), auditCarSubsidyVo.getMonthlyAmount());
        return resultMap;
    }
}

