/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftNumberRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(GiftNumberRegister.class);
    @Autowired(required=false)
    private TpmDailySalesDataService tpmDailySalesDataService;

    public String getVariableCode() {
        return "giftNumber";
    }

    public String getVariableName() {
        return "\u8d60\u54c1\u6570\u91cf\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String startTimeStr = DateUtil.dateToStr((Date)calculateDto.getStartTimeOrDate(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        String endTimeStr = DateUtil.dateToStr((Date)calculateDto.getEndTimeOrDate(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        TpmDailySalesDataDto tpmDailySalesDataDto = new TpmDailySalesDataDto();
        tpmDailySalesDataDto.setCustomerCode(calculateDto.getCustomerCode());
        tpmDailySalesDataDto.setMaterialCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        tpmDailySalesDataDto.setStartTimeStr(startTimeStr.replaceAll("-", ""));
        tpmDailySalesDataDto.setEndTimeStr(endTimeStr.replaceAll("-", ""));
        if (!StringUtils.isEmpty((CharSequence)calculateDto.getSalesOrgCode())) {
            tpmDailySalesDataDto.setSalesInstitutionCode(calculateDto.getSalesOrgCode());
        }
        TpmDailySalesDataVo tpmDailySalesDataVo = this.tpmDailySalesDataService.findGift(tpmDailySalesDataDto);
        BigDecimal giftNum = new BigDecimal(0);
        if (!Objects.isNull(tpmDailySalesDataVo)) {
            giftNum = tpmDailySalesDataVo.getGiftNum();
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), giftNum);
        return resultMap;
    }
}

