/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.MemberRedPacketDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.service.RedPayLedgerVoService;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.MemberRedPacketVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedEnvelopePaymentAmountRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(RedEnvelopePaymentAmountRegister.class);
    @Autowired(required=false)
    private RedPayLedgerVoService redPayLedgerVoService;

    public String getVariableCode() {
        return "redEnvelopePaymentAmount";
    }

    public String getVariableName() {
        return "\u7ea2\u5305\u5151\u4ed8\u91d1\u989d\uff08\u4e3b\u4f53\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getActivitiesDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MemberRedPacketDto memberRedPacketDto = new MemberRedPacketDto();
        memberRedPacketDto.setPlanItemCode(calculateDto.getActivitiesDetailCode());
        List memberRedPacketVos = this.redPayLedgerVoService.findByPlanItemCode(memberRedPacketDto);
        BigDecimal amount = new BigDecimal(0);
        if (CollectionUtils.isNotEmpty((Collection)memberRedPacketVos)) {
            amount = memberRedPacketVos.stream().map(MemberRedPacketVo::getRedPacketAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        resultMap.put(this.getVariableCode(), amount);
        return resultMap;
    }
}

