/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StoreGmvRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(StoreGmvRegister.class);
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "storeGmvMain";
    }

    public String getVariableName() {
        return "\u95e8\u5e97GMV-\u4e3b\u4f53";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String customerCode = calculateDto.getCustomerCode();
        Validate.notNull((Object)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String salesOrgCode = calculateDto.getSalesOrgCode();
        Validate.notNull((Object)salesOrgCode, (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String yearMonthLy = calculateDto.getYearMonthLy();
        Validate.notNull((Object)yearMonthLy, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
        try {
            indicatorDto.setYearAndMonth(DateUtil.date_yyyy_MM.parse(yearMonthLy));
            indicatorDto.setYearAndMonthStr(DateUtil.date_yyyyMMdd.format(indicatorDto.getYearAndMonth()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5e74\u6708\u7684\u683c\u5f0f\u5e94\u4e3a\u3010yyyy-MM\u3011!");
        }
        indicatorDto.setCustomerCode(customerCode);
        indicatorDto.setSalesOrgCode(salesOrgCode);
        indicatorDto.setVariableCode(this.getVariableCode());
        List indicatorVos = this.auditExecuteIndicatorService.findData(indicatorDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        if (CollectionUtils.isEmpty((Collection)indicatorVos)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)indicatorVos.get(0)).getIndicatorValue());
        return resultMap;
    }
}

