/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.budget;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetDepartmentBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.variable.local.register.budget.helper.HeadMonthBudgetVariableHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.VariableSelectBudgetDto;
import com.biz.crm.tpm.business.variable.sdk.enums.QuarterEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableP0006Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VariableP0006Register.class);
    @Autowired(required=false)
    private HeadMonthBudgetVariableHelper headMonthBudgetVariableHelper;

    public String getVariableCode() {
        return "P0006";
    }

    public String getVariableName() {
        return "\u5927\u533a\u884c\u9500\u8d39\u7528-\u8d39\u7528\u8fdb\u5ea6-Q2";
    }

    public Integer getSort() {
        return 7;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.BUDGET);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getOrgCode(), (String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        VariableSelectBudgetDto dto = new VariableSelectBudgetDto();
        dto.setQuarter(QuarterEnum.Q2.getCode());
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
        dto.setDepartmentBelongCode(BudgetDepartmentBelongEnum.MARKET.getCode());
        dto.setOrgCode(calculateDto.getOrgCode());
        dto.setBudgetItemCode(calculateDto.getBudgetItemCode());
        dto.setOrgCode(calculateDto.getOrgCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        List<String> budgetItemCodes = this.headMonthBudgetVariableHelper.calculateVariable(dto);
        Validate.notEmpty(budgetItemCodes, (String)("\u672a\u627e\u5230\u9884\u7b97\u9879\u76ee\uff01\u6307\u6807[" + this.getVariableName() + "}"), (Object[])new Object[0]);
        dto.setBudgetItemCodes(budgetItemCodes);
        Map<String, MonthBudgetVo> monthBudgetForVariableMapOne = this.headMonthBudgetVariableHelper.findMonthBudgetRegionMarketingCost(dto);
        Validate.notEmpty(monthBudgetForVariableMapOne, (String)("\u672a\u627e\u5230\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff01\u6307\u6807[" + this.getVariableName() + "}"), (Object[])new Object[0]);
        dto.setQuarter(null);
        String year = dto.getYearMonthLy().substring(0, 4);
        dto.setYearMonthLy(year + "-03");
        Map<String, MonthBudgetVo> monthBudgetForVariableMapTwo = this.headMonthBudgetVariableHelper.findMonthBudgetRegionMarketingCost(dto);
        Validate.notEmpty(monthBudgetForVariableMapTwo, (String)("\u672a\u627e\u5230" + dto.getYearMonthLy() + "\u6708\u7684\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff01\u6307\u6807[" + this.getVariableName() + "}"), (Object[])new Object[0]);
        monthBudgetForVariableMapOne.forEach((k, v) -> {
            BigDecimal resultValue = BigDecimal.ZERO;
            MonthBudgetVo last = (MonthBudgetVo)monthBudgetForVariableMapTwo.get(k);
            Validate.notNull((Object)last, (String)("\u672a\u627e\u52303\u6708\u9884\u7b97\u9879\u76ee\u4e3a[" + k + "]\u7684\u6708\u5ea6\u9884\u7b97"), (Object[])new Object[0]);
            BigDecimal lastApprovedAuditDiff = Optional.ofNullable(last.getApprovedAuditDiff()).orElse(BigDecimal.ZERO);
            BigDecimal numerator = BigDecimal.ZERO;
            if (!Objects.isNull(v.getAuditAmount())) {
                numerator = v.getAuditAmount();
            } else if (!Objects.isNull(v.getApprovedAmount())) {
                numerator = v.getApprovedAmount();
            }
            BigDecimal denominator = Optional.ofNullable(v.getInitResolveAmount()).orElse(BigDecimal.ZERO);
            log.info("\u5927\u533a\u884c\u9500\u8d39\u7528-\u8d39\u7528\u8fdb\u5ea6-Q2,\u9884\u7b97\u9879\u76ee[" + k + "],\u7ed3\u6848\u91d1\u989d\u6216\u6279\u590d\u91d1\u989d:{},\u5e74\u521d\u5206\u89e3\u91d1\u989d:{},\u7ed3\u6848\u6279\u590d\u5dee:{}", new Object[]{numerator, denominator, lastApprovedAuditDiff});
            if (BigDecimal.ZERO.compareTo(denominator) == 0) {
                resultMap.put((String)k, BigDecimal.ZERO);
            } else {
                resultValue = resultValue.add(lastApprovedAuditDiff);
                resultValue = numerator.divide(denominator, 6, 4);
                resultMap.put((String)k, resultValue);
            }
        });
        return resultMap;
    }
}

