/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.budget;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetDepartmentBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.variable.local.register.budget.helper.HeadMonthBudgetVariableHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.VariableSelectBudgetDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableP0008Register
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VariableP0008Register.class);
    @Autowired(required=false)
    private HeadMonthBudgetVariableHelper headMonthBudgetVariableHelper;

    public String getVariableCode() {
        return "P0008";
    }

    public String getVariableName() {
        return "\u603b\u90e8\u9500\u552e\u5e38\u89c4-\u8d39\u7528\u8fdb\u5ea6-\u9500\u91cf\u8fdb\u5ea6-\u7d2f\u8ba1\u6708\u5ea6";
    }

    public Integer getSort() {
        return 9;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.BUDGET);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        VariableSelectBudgetDto dto = new VariableSelectBudgetDto();
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setFeeBelongCode(FeeBelongEnum.HEAD.getCode());
        dto.setDepartmentBelongCode(BudgetDepartmentBelongEnum.SALE_MANAGE.getCode());
        dto.setBudgetItemCode(calculateDto.getBudgetItemCode());
        List<String> budgetItemCodes = this.headMonthBudgetVariableHelper.calculateVariable(dto);
        Validate.notEmpty(budgetItemCodes, (String)("\u672a\u627e\u5230\u9884\u7b97\u9879\u76ee\uff01\u6307\u6807[" + this.getVariableName() + "]"), (Object[])new Object[0]);
        dto.setBudgetItemCodes(budgetItemCodes);
        List<MonthBudgetVo> monthBudgetVoList = this.headMonthBudgetVariableHelper.findMonthBudgetConditionForVariable(dto);
        Validate.notEmpty(monthBudgetVoList, (String)("\u672a\u627e\u5230,\u8ba1\u7b97\u6307\u6807[" + this.getVariableName() + "],\u6240\u9700\u8981\u7684\u6708\u5ea6\u9884\u7b97\u6570\u636e\uff01"), (Object[])new Object[0]);
        Map<String, List<MonthBudgetVo>> monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.groupingBy(MonthBudgetVo::getBudgetItemCode));
        monthBudgetVoMap.forEach((k, v) -> {
            BigDecimal minuend = BigDecimal.ZERO;
            BigDecimal auditAmount = BigDecimal.ZERO;
            BigDecimal initResolveAmount = v.stream().map(MonthBudgetVo::getInitResolveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(initResolveAmount) != 0) {
                auditAmount = v.stream().map(MonthBudgetVo::getAuditAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (BigDecimal.ZERO.compareTo(auditAmount) == 0) {
                    auditAmount = v.stream().map(MonthBudgetVo::getApprovedAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                minuend = auditAmount.divide(initResolveAmount, 6, 4);
            }
            BigDecimal subtrahend = BigDecimal.ZERO;
            for (MonthBudgetVo monthBudgetVo : v) {
                BigDecimal actualSales = Optional.ofNullable(monthBudgetVo.getActualSales()).orElse(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(actualSales) == 0) continue;
                BigDecimal budgetTotalPoint = Optional.ofNullable(monthBudgetVo.getBudgetTotalPoint()).orElse(BigDecimal.ZERO);
                subtrahend.add(actualSales.multiply(budgetTotalPoint).divide(actualSales, 6, 4));
            }
            log.info("\u603b\u90e8\u9500\u552e\u5e38\u89c4-\u8d39\u7528\u8fdb\u5ea6-\u9500\u91cf\u8fdb\u5ea6-\u7d2f\u8ba1\u6708\u5ea6,\u9884\u7b97\u9879\u76ee[" + k + "],\u7ed3\u6848\u91d1\u989d\u6216\u6279\u590d\u91d1\u989d:{},\u5e74\u521d\u5206\u89e3\u91d1\u989d:{},\u5b9e\u9645\u9500\u552e\u91d1\u989d/\u5b9e\u9645\u9500\u91cf\u9884\u7b97\uff08\u5b9e\u9500\u91d1\u989d\uff09\u603b\u8ba1:{}", new Object[]{auditAmount, initResolveAmount, subtrahend});
            resultMap.put((String)k, minuend.subtract(subtrahend));
        });
        return resultMap;
    }
}

