/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.budget.helper;

import com.alibaba.excel.util.StringUtils;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemControlConditionVoService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.variable.sdk.dto.VariableSelectBudgetDto;
import com.biz.crm.tpm.business.variable.sdk.enums.QuarterEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeadMonthBudgetVariableHelper {
    private static final Logger log = LoggerFactory.getLogger(HeadMonthBudgetVariableHelper.class);
    @Autowired(required=false)
    private BudgetItemControlConditionVoService budgetItemControlConditionVoService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    public List<String> calculateVariable(VariableSelectBudgetDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeBelongCode(), (String)"\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDepartmentBelongCode(), (String)"\u90e8\u95e8\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BudgetItemControlConditionDto conditionDto = new BudgetItemControlConditionDto();
        conditionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        conditionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        conditionDto.setFeeBelongCode(dto.getFeeBelongCode());
        conditionDto.setDepartmentBelongCode(dto.getDepartmentBelongCode());
        conditionDto.setBudgetItemCode(dto.getBudgetItemCode());
        log.info("\u9884\u7b97\u6574\u4f53\u7ba1\u63a7\u67e5\u8be2\u9884\u7b97\u9879\u76ee,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)conditionDto));
        List budgetItemCodes = this.budgetItemControlConditionVoService.findCodeForVariable(conditionDto);
        log.info("\u9884\u7b97\u6574\u4f53\u7ba1\u63a7\u67e5\u8be2\u9884\u7b97\u9879\u76ee,budgetItemCodes.size:{}", (Object)budgetItemCodes.size());
        if (CollectionUtils.isEmpty((Collection)budgetItemCodes)) {
            return Lists.newArrayList();
        }
        return budgetItemCodes;
    }

    public Map<String, MonthBudgetVo> findMonthBudgetRegionMarketingCost(VariableSelectBudgetDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeBelongCode(), (String)"\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getBudgetItemCodes(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        monthBudgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        monthBudgetDto.setFeeBelongCode(dto.getFeeBelongCode());
        monthBudgetDto.setOrgCode(dto.getOrgCode());
        monthBudgetDto.setBudgetItemCodeList(dto.getBudgetItemCodes());
        String year = dto.getYearMonthLy().substring(0, 4);
        ArrayList<String> yearMonthList = new ArrayList<String>();
        if (QuarterEnum.Q1.getCode().equals(dto.getQuarter())) {
            yearMonthList.add(year + "-01");
            yearMonthList.add(year + "-02");
            yearMonthList.add(year + "-03");
        }
        if (QuarterEnum.Q2.getCode().equals(dto.getQuarter())) {
            yearMonthList.add(year + "-04");
            yearMonthList.add(year + "-05");
            yearMonthList.add(year + "-06");
        }
        if (QuarterEnum.Q3.getCode().equals(dto.getQuarter())) {
            yearMonthList.add(year + "-07");
            yearMonthList.add(year + "-08");
            yearMonthList.add(year + "-09");
        }
        if (StringUtils.isBlank((CharSequence)dto.getQuarter())) {
            monthBudgetDto.setYearMonthLy(dto.getYearMonthLy());
        } else {
            monthBudgetDto.setYearMonthLyList(yearMonthList);
        }
        log.info("\u9884\u7b97\u6574\u4f53\u7ba1\u63a7\u67e5\u8be2\u6708\u5ea6\u9884\u7b97,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)monthBudgetDto));
        List monthBudgetVoList = this.monthBudgetService.findMonthBudgetForVariable(monthBudgetDto);
        log.info("\u9884\u7b97\u6574\u4f53\u7ba1\u63a7\u67e5\u8be2\u6708\u5ea6\u9884\u7b97,monthBudgetVoList.size:{}", (Object)monthBudgetVoList.size());
        if (CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
            return Maps.newHashMap();
        }
        Map<String, MonthBudgetVo> map = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getBudgetItemCode, Function.identity()));
        return map;
    }

    public List<MonthBudgetVo> findMonthBudgetConditionForVariable(VariableSelectBudgetDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeBelongCode(), (String)"\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getBudgetItemCodes(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        monthBudgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        monthBudgetDto.setFeeBelongCode(dto.getFeeBelongCode());
        monthBudgetDto.setBudgetItemCodeList(dto.getBudgetItemCodes());
        log.info("\u9884\u7b97\u6574\u4f53\u7ba1\u63a7\u67e5\u8be2\u6708\u5ea6\u9884\u7b97,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)monthBudgetDto));
        List monthBudgetVoList = this.monthBudgetService.findMonthBudgetConditionForVariable(monthBudgetDto);
        log.info("\u9884\u7b97\u6574\u4f53\u7ba1\u63a7\u67e5\u8be2\u6708\u5ea6\u9884\u7b97,monthBudgetVoList.size:{}", (Object)monthBudgetVoList.size());
        if (CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
            return Lists.newArrayList();
        }
        return monthBudgetVoList;
    }
}

