/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.common;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceRegisterParamBuilder {
    private static final Logger log = LoggerFactory.getLogger(PriceRegisterParamBuilder.class);

    public static SearchPriceDto buildParam(CalculateDto calculateDto, PriceTypeEnum priceTypeEnum) {
        SearchPriceDto searchPrice = new SearchPriceDto();
        searchPrice.setPriceTypeCode(priceTypeEnum.getDictCode());
        searchPrice.setDimensionItems(PriceRegisterParamBuilder.buildDimensionItems(calculateDto));
        searchPrice.setSearchTime(calculateDto.getSearchTime());
        log.info("\u6307\u6807\u8be2\u4ef7\u53c2\u6570=====\u300b{}", (Object)JSONObject.toJSONString((Object)searchPrice));
        return searchPrice;
    }

    public static List<SearchPriceDimensionItemDto> buildDimensionItems(CalculateDto calculateDto) {
        ArrayList<SearchPriceDimensionItemDto> itemDtos = new ArrayList<SearchPriceDimensionItemDto>();
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.CHANNEL, calculateDto.getChannel(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.MATERIAL, calculateDto.getProductCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.PRODUCT_GROUP, calculateDto.getBusinessFormatCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.CUSTOMER, calculateDto.getCustomerErpCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.SALES_ORG_CODE, calculateDto.getSalesOrgErpCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.SALES_INSTITUTION_CODE, calculateDto.getSalesOrganizationErpCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.SALES_GROUP, calculateDto.getSalesGroupErpCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.ORG_CODE, calculateDto.getBusinessFormatCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.DISTRIBUTION_CHANNEL, calculateDto.getDistributionChannel(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.SELLER_CODE, calculateDto.getCustomerErpCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.DELIVERY_CODE, calculateDto.getStoresCode(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.SALE_REGION, calculateDto.getSaleRegion(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.PRICE_AREA, calculateDto.getPriceArea(), itemDtos);
        PriceRegisterParamBuilder.buildDimensionItem(PriceDimensionEnum.SALE_UNIT, "PC", itemDtos);
        return itemDtos;
    }

    public static void buildDimensionItem(PriceDimensionEnum dimensionEnum, String value, List<SearchPriceDimensionItemDto> itemDtos) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            SearchPriceDimensionItemDto dimensionItemDto = new SearchPriceDimensionItemDto();
            dimensionItemDto.setDimensionCode(dimensionEnum.getDictCode());
            dimensionItemDto.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{value}));
            itemDtos.add(dimensionItemDto);
        }
    }
}

